/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.create.geometrycol;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.geometry.jts.WKTReader2;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnProperties;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.StringValue;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CreatePointFromGeometryColNodeModel
extends NodeModel {
    private final SettingsModelString m_colname_geom = new SettingsModelString("colname_geom", null);
    private final SettingsModelBoolean m_delete_geom = new SettingsModelBoolean("delete_geom", Boolean.TRUE.booleanValue());
    private final SettingsModelString m_crs = new SettingsModelString("crs", SpatialUtils.getDefaultCRSString());

    protected CreatePointFromGeometryColNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (spec == null) {
            throw new InvalidSettingsException("no table as input");
        }
        if (spec.containsName("the_geom")) {
            throw new InvalidSettingsException("the input table already contains a column named the_geom");
        }
        if (!spec.containsName(this.m_colname_geom.getStringValue())) {
            throw new InvalidSettingsException("unknown column " + this.m_colname_geom.getStringValue() + " in the table");
        }
        CoordinateReferenceSystem crsTarget = SpatialUtils.getCRSforString((String)this.m_crs.getStringValue());
        return new DataTableSpec[]{this.createOutputSpec(spec)};
    }

    private DataTableSpec createOutputSpec(DataTableSpec inputTableSpec) {
        String colname_geom = this.m_colname_geom.getStringValue();
        boolean delete_geom = this.m_delete_geom.getBooleanValue();
        CoordinateReferenceSystem crsTarget = SpatialUtils.getCRSforString((String)this.m_crs.getStringValue());
        ArrayList<DataColumnSpec> newColumnSpecs = new ArrayList<DataColumnSpec>(inputTableSpec.getNumColumns() + 1);
        int i = 0;
        while (i < inputTableSpec.getNumColumns()) {
            String name = inputTableSpec.getColumnNames()[i];
            if (!delete_geom || !colname_geom.equals(name)) {
                newColumnSpecs.add(inputTableSpec.getColumnSpec(i));
            }
            ++i;
        }
        HashMap<String, String> properties = new HashMap<String, String>(inputTableSpec.getProperties());
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)crsTarget));
        properties.put("crs WKT", crsTarget.toWKT());
        DataColumnSpecCreator creator = new DataColumnSpecCreator("the_geom", StringCell.TYPE);
        creator.setProperties(new DataColumnProperties(properties));
        newColumnSpecs.add(creator.createSpec());
        return new DataTableSpec(newColumnSpecs.toArray(new DataColumnSpec[newColumnSpecs.size()]));
    }

    protected void setWarningMessage(int countMissing, int countErrors) {
        if (countMissing == 0 && countErrors == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer("there are ");
        if (countMissing > 0) {
            sb.append(countMissing).append(" entities missing geometry");
        }
        if (countErrors > 0) {
            if (countMissing > 0) {
                sb.append(" and");
            }
            sb.append(countErrors).append(" errors in geometries");
        }
        this.setWarningMessage(sb.toString());
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inputTable = inData[0];
        DataTableSpec outputSpec = this.createOutputSpec(inputTable.getDataTableSpec());
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        boolean delete_geom = this.m_delete_geom.getBooleanValue();
        int idxColumnGeom = inputTable.getSpec().findColumnIndex(this.m_colname_geom.getStringValue());
        GeometryFactory gf = new GeometryFactory();
        WKTReader2 reader = new WKTReader2(gf);
        int countMissing = 0;
        int countError = 0;
        exec.setProgress(0.0, "processing");
        long total = inputTable.size();
        long done = 0L;
        CloseableRowIterator itRow = inputTable.iterator();
        while (itRow.hasNext()) {
            DataRow row = itRow.next();
            List cells = null;
            if (delete_geom) {
                cells = new ArrayList(row.getNumCells() - 1);
                int i = 0;
                while (i < row.getNumCells()) {
                    if (i != idxColumnGeom) {
                        cells.add(row.getCell(i));
                    }
                    ++i;
                }
            } else {
                cells = row.stream().collect(Collectors.toList());
            }
            DataCell cell = row.getCell(idxColumnGeom);
            if (cell.isMissing()) {
                cells.add(cell);
                this.setWarningMessage(++countMissing, countError);
            } else {
                String wkt = ((StringValue)cell).getStringValue();
                try {
                    Geometry geom = reader.read(wkt);
                    cells.add(StringCell.StringCellFactory.create((String)geom.toString()));
                }
                catch (ParseException e) {
                    this.setWarningMessage(countMissing, ++countError);
                    this.getLogger().warn((Object)("unable to decode the geometry \"" + wkt + "\" in row " + row.getKey() + ": " + e.getMessage()));
                }
            }
            container.addRowToTable((DataRow)new DefaultRow(row.getKey(), cells));
            if (++done % 20L != 0L) continue;
            exec.checkCanceled();
            exec.setProgress((double)done / (double)total, "processing row " + row.getKey());
        }
        itRow.close();
        exec.setProgress(1.0, "closing...");
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_colname_geom.saveSettingsTo(settings);
        this.m_delete_geom.saveSettingsTo(settings);
        this.m_crs.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname_geom.loadSettingsFrom(settings);
        this.m_delete_geom.loadSettingsFrom(settings);
        this.m_crs.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname_geom.validateSettings(settings);
        this.m_delete_geom.validateSettings(settings);
        this.m_crs.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

