/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.read.read_from_geofabrik;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.read.read_from_geofabrik.ReadWKTFromGeofabrikNodeModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.knime.core.node.NodeLogger;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeofabrikUtils {
    private static final NodeLogger logger = NodeLogger.getLogger(ReadWKTFromGeofabrikNodeModel.class);
    public static final String URL_INDEX_GEOFABRIK = "https://download.geofabrik.de/index-v1.json";
    private static final Object lockDownloadGeofabrikIndex = new Object();
    public static final Map<String, Object> filecode2lock = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File readGeofabrikIndexIntoFile() {
        try {
            URL url = new URL("https://download.geofabrik.de/index-v1.json");
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            InputStream inputStream = connection.getInputStream();
            File f = new File(GeofabrikUtils.getFileForCache(), "index-v1.json");
            Object object = lockDownloadGeofabrikIndex;
            synchronized (object) {
                if (f.exists()) {
                    return f;
                }
                FileWriter fileWriter = new FileWriter(f);
                IOUtils.copy((InputStream)inputStream, (Writer)fileWriter, (Charset)StandardCharsets.UTF_8);
                fileWriter.flush();
                fileWriter.close();
                return f;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("unable to read the file");
        }
    }

    public static CompletableFuture<Map<String, String>> obtainListOfDataExtracts() {
        return CompletableFuture.supplyAsync(new /* Unavailable Anonymous Inner Class!! */);
    }

    public static Map<String, String> fetchListOfDataExtracts() {
        File f = null;
        try {
            String parent;
            f = GeofabrikUtils.readGeofabrikIndexIntoFile();
            JSONTokener tokener = new JSONTokener((InputStream)new FileInputStream(f));
            JSONObject root = new JSONObject(tokener);
            JSONArray features = root.getJSONArray("features");
            HashMap<String, String> name2url = new HashMap<String, String>();
            HashMap<String, String> id2parent = new HashMap<String, String>();
            HashMap<String, String> id2name = new HashMap<String, String>();
            int i = 0;
            while (i < features.length()) {
                JSONObject feature = (JSONObject)features.get(i);
                JSONObject properties = feature.getJSONObject("properties");
                String id = properties.getString("id");
                String name = properties.getString("name");
                logger.warn((Object)("id = " + id + ", name = " + name));
                id2name.put(id, name);
                parent = null;
                if (properties.has("parent")) {
                    parent = properties.getString("parent");
                }
                if (parent != null) {
                    id2parent.put(id, parent);
                    logger.warn((Object)(String.valueOf(id) + " has for parent " + parent));
                } else {
                    logger.warn((Object)(String.valueOf(id) + " has no parent"));
                }
                JSONObject urls = properties.getJSONObject("urls");
                if (urls.has("shp")) {
                    String shp = urls.getString("shp");
                    name2url.put(id, shp);
                }
                ++i;
            }
            TreeMap<String, String> hierarchy2url = new TreeMap<String, String>();
            for (String id : name2url.keySet()) {
                String url = (String)name2url.get(id);
                String newId = (String)id2name.get(id);
                parent = (String)id2parent.get(id);
                while (parent != null) {
                    logger.warn((Object)("for id " + newId + " we found parent " + parent));
                    newId = String.valueOf((String)id2name.get(parent)) + "/" + newId;
                    id = parent;
                    parent = (String)id2parent.get(id);
                }
                hierarchy2url.put(newId, url);
                logger.warn((Object)(String.valueOf(newId) + " => " + url));
            }
            return hierarchy2url;
        }
        catch (JSONException e1) {
            e1.printStackTrace();
            if (f != null) {
                f.delete();
            }
            throw new RuntimeException("error while parsing file https://download.geofabrik.de/index-v1.json", e1);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("unable to access the list of data from https://download.geofabrik.de/index-v1.json", e);
        }
    }

    public static File getFileForCache() {
        File dir = new File(SpatialUtils.getFileForCache(), "geofabrik");
        dir.mkdirs();
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getLockForFile(String filecode) {
        Map map = filecode2lock;
        synchronized (map) {
            if (!filecode2lock.containsKey(filecode)) {
                filecode2lock.put(filecode, new Object());
            }
            return filecode2lock.get(filecode);
        }
    }
}

