/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.transform.relate;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.transform.relate.RelateWKTGeometriesNodeModel;
import java.io.File;
import java.io.IOException;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataTableSpecCreator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RelateWKTGeometriesNodeModel
extends NodeModel {
    private SettingsModelString m_relationship = new SettingsModelString("relationship", "intersects");
    private SettingsModelString m_colname = new SettingsModelString("colname", "result");
    long done = 0L;

    protected RelateWKTGeometriesNodeModel() {
        super(2, 1);
    }

    protected DataColumnSpec createColumnSpec() throws InvalidSettingsException {
        String colname = this.m_colname.getStringValue();
        return new DataColumnSpecCreator(colname, BooleanCell.TYPE).createSpec();
    }

    protected DataTableSpec createDataSpec(DataTableSpec spec) throws InvalidSettingsException {
        DataTableSpecCreator creator = new DataTableSpecCreator(spec);
        creator.addColumns(new DataColumnSpec[]{this.createColumnSpec()});
        return creator.createSpec();
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        CoordinateReferenceSystem crs2;
        DataTableSpec spec1 = inSpecs[0];
        if (spec1 == null) {
            throw new InvalidSettingsException("no top table as input");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec1)) {
            throw new InvalidSettingsException("the top input table contains no WKT geometry");
        }
        DataTableSpec spec2 = inSpecs[0];
        if (spec2 == null) {
            throw new InvalidSettingsException("no bottom table as input");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec2)) {
            throw new InvalidSettingsException("the bottom input table contains no WKT geometry");
        }
        CoordinateReferenceSystem crs1 = SpatialUtils.decodeCRS((DataTableSpec)spec1);
        if (!crs1.equals(crs2 = SpatialUtils.decodeCRS((DataTableSpec)spec2))) {
            throw new InvalidSettingsException("the two tables are not spatialized on the same Coordinate Reference Sytems; please reproject them first");
        }
        return new DataTableSpec[]{this.createDataSpec(spec1)};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        if (!ReferencingFactoryFinder.getAuthorityNames().contains("AUTO")) {
            throw new RuntimeException("No factory for autority AUTO");
        }
        BufferedDataTable inputTable1 = inData[0];
        BufferedDataTable inputTable2 = inData[1];
        if (inputTable1.size() != inputTable2.size()) {
            throw new InvalidSettingsException("the two tables should have the same number of rows");
        }
        DataTableSpec outputSpec = this.createDataSpec(inputTable1.getDataTableSpec());
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        double total = inputTable1.size();
        int numberOfCells = inputTable1.getDataTableSpec().getNumColumns();
        String relationship = this.m_relationship.getStringValue();
        DisjointComputer computer = null;
        if (relationship.equals("disjoint")) {
            computer = new DisjointComputer(null);
        } else if (relationship.equals("intersects")) {
            computer = new IntersectsComputer(null);
        } else if (relationship.equals("touches")) {
            computer = new TouchesComputer(null);
        } else if (relationship.equals("crosses")) {
            computer = new CrossesComputer(null);
        } else if (relationship.equals("within")) {
            computer = new WithinComputer(null);
        } else if (relationship.equals("contains")) {
            computer = new ContainsComputer(null);
        } else if (relationship.equals("overlaps")) {
            computer = new OverlapsComputer(null);
        } else if (relationship.equals("equals")) {
            computer = new EqualsComputer(null);
        } else {
            throw new RuntimeException("Unknown operation: " + relationship);
        }
        DisjointComputer computerFinal = computer;
        this.done = 0L;
        SpatialUtils.applyToEachGeometry((BufferedDataTable)inputTable1, (BufferedDataTable)inputTable2, arg_0 -> this.lambda$0(numberOfCells, (IRelationComputer)computerFinal, container, exec, total, arg_0));
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_relationship.saveSettingsTo(settings);
        this.m_colname.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_relationship.loadSettingsFrom(settings);
        this.m_colname.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_relationship.validateSettings(settings);
        this.m_colname.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }

    private /* synthetic */ void lambda$0(int n, IRelationComputer iRelationComputer, BufferedDataContainer bufferedDataContainer, ExecutionContext executionContext, double d, SpatialUtils.RowsAndGeometrys geomsAndRows) throws CanceledExecutionException, InvalidSettingsException {
        DataCell[] cells = new DataCell[n + 1];
        int i = 0;
        while (i < n) {
            cells[i] = geomsAndRows.row1.getCell(i);
            ++i;
        }
        cells[n] = BooleanCell.BooleanCellFactory.create((boolean)iRelationComputer.compute(geomsAndRows.geometry1, geomsAndRows.geometry2));
        DefaultRow row = new DefaultRow(geomsAndRows.row1.getKey(), cells);
        bufferedDataContainer.addRowToTable((DataRow)row);
        executionContext.checkCanceled();
        executionContext.setProgress((double)this.done++ / d, "computing " + this.done + "th rows");
    }
}

