/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.read.read_from_geofabrik;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.read.read_from_geofabrik.ReadWKTFromGeofabrikNodeModel;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import org.geotools.data.FileDataStore;
import org.geotools.data.geojson.GeoJSONDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.knime.core.node.NodeLogger;
import org.opengis.feature.simple.SimpleFeature;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeofabrikUtils {
    private static final NodeLogger logger = NodeLogger.getLogger(ReadWKTFromGeofabrikNodeModel.class);
    public static final String URL_INDEX_GEOFABRIK = "https://download.geofabrik.de/index-v1.json";
    private static final Object lockDownloadGeofabrikIndex = new Object();
    public static final Map<String, Object> filecode2lock = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File readGeofabrikIndexIntoFile() {
        try {
            URL url = new URL("https://download.geofabrik.de/index-v1.json");
            InputStream inputStream = url.openStream();
            File f = new File(GeofabrikUtils.getFileForCache(), "index-v1.json");
            Object object = lockDownloadGeofabrikIndex;
            synchronized (object) {
                if (f.exists()) {
                    return f;
                }
                FileWriter fileWriter = new FileWriter(f);
                IOUtils.copy((InputStream)inputStream, (Writer)fileWriter, (Charset)StandardCharsets.UTF_8);
                return f;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("unable to read the file");
        }
    }

    public static CompletableFuture<Map<String, String>> obtainListOfDataExtracts() {
        return CompletableFuture.supplyAsync(new /* Unavailable Anonymous Inner Class!! */);
    }

    public static Map<String, String> fetchListOfDataExtracts() {
        GeoJSONDataStoreFactory factory = new GeoJSONDataStoreFactory();
        FileDataStore store = null;
        SimpleFeatureIterator it = null;
        try {
            File f = GeofabrikUtils.readGeofabrikIndexIntoFile();
            store = factory.createDataStore(f);
            SimpleFeatureCollection features = store.getFeatureSource(store.getTypeNames()[0]).getFeatures();
            it = features.features();
            HashMap<String, String> name2url = new HashMap<String, String>();
            HashMap<String, String> id2parent = new HashMap<String, String>();
            HashMap<String, String> id2name = new HashMap<String, String>();
            while (it.hasNext()) {
                SimpleFeature ft = (SimpleFeature)it.next();
                logger.warn((Object)("processing feature " + ft.toString()));
                String id = ft.getAttribute("id").toString();
                String name = ft.getAttribute("name").toString();
                logger.warn((Object)("id = " + id + ", name = " + name));
                id2name.put(id, name);
                String parent = (String)ft.getAttribute("parent");
                if (parent != null) {
                    id2parent.put(id, parent);
                    logger.warn((Object)(String.valueOf(id) + " has for parent " + parent));
                } else {
                    logger.warn((Object)(String.valueOf(id) + " has no parent"));
                }
                ObjectNode urls = (ObjectNode)ft.getAttribute("urls");
                JsonNode nodeShp = urls.findValue("shp");
                if (nodeShp == null) continue;
                String shp = nodeShp.asText();
                name2url.put(id, shp);
            }
            TreeMap<String, String> hierarchy2url = new TreeMap<String, String>();
            for (String id : name2url.keySet()) {
                String url = (String)name2url.get(id);
                String newId = (String)id2name.get(id);
                String parent = (String)id2parent.get(id);
                while (parent != null) {
                    logger.warn((Object)("for id " + newId + " we found parent " + parent));
                    newId = String.valueOf((String)id2name.get(parent)) + "/" + newId;
                    id = parent;
                    parent = (String)id2parent.get(id);
                }
                hierarchy2url.put(newId, url);
                logger.warn((Object)(String.valueOf(newId) + " => " + url));
            }
            TreeMap<String, String> treeMap = hierarchy2url;
            return treeMap;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("The index URL seems corrupted: https://download.geofabrik.de/index-v1.json", e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("unable to access the list of data from https://download.geofabrik.de/index-v1.json", e);
        }
        finally {
            if (it != null) {
                it.close();
            }
            if (store != null) {
                store.dispose();
            }
        }
    }

    public static File getFileForCache() {
        File dir = new File(SpatialUtils.getFileForCache(), "geofabrik");
        dir.mkdirs();
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getLockForFile(String filecode) {
        Map map = filecode2lock;
        synchronized (map) {
            if (!filecode2lock.containsKey(filecode)) {
                filecode2lock.put(filecode, new Object());
            }
            return filecode2lock.get(filecode);
        }
    }
}

