/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.properties.globalboundingbox;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnProperties;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.data.def.IntCell;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GlobalBoundingBoxNodeModel
extends NodeModel {
    long done = 0L;

    protected GlobalBoundingBoxNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (spec == null) {
            throw new InvalidSettingsException("no table as input");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec)) {
            throw new InvalidSettingsException("the input table contains no WKT geometry");
        }
        return new DataTableSpec[]{this.createOutputSpec(spec)};
    }

    private DataTableSpec createOutputSpec(DataTableSpec inputTableSpec) {
        CoordinateReferenceSystem crs = SpatialUtils.decodeCRS((DataTableSpec)inputTableSpec);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)crs));
        properties.put("crs WKT", crs.toWKT());
        DataColumnSpecCreator creator = new DataColumnSpecCreator("the_geom", StringCell.TYPE);
        creator.setProperties(new DataColumnProperties(properties));
        ArrayList<DataColumnSpec> newColumnSpecs = new ArrayList<DataColumnSpec>(2);
        newColumnSpecs.add(creator.createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("id", IntCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("x1", DoubleCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("y1", DoubleCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("x2", DoubleCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("y2", DoubleCell.TYPE).createSpec());
        return new DataTableSpec(newColumnSpecs.toArray(new DataColumnSpec[newColumnSpecs.size()]));
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        if (!ReferencingFactoryFinder.getAuthorityNames().contains("AUTO")) {
            throw new RuntimeException("No factory for autority AUTO");
        }
        BufferedDataTable inputTable = inData[0];
        CoordinateReferenceSystem crs = SpatialUtils.decodeCRS((DataTableSpec)inputTable.getDataTableSpec());
        ReferencedEnvelope globalEnvelope = new ReferencedEnvelope(crs);
        double total = inputTable.size();
        SpatialUtils.applyToEachGeometry((BufferedDataTable)inputTable, geomAndRow -> {
            if (this.done++ % 10L == 0L) {
                exec.checkCanceled();
                exec.setProgress((double)this.done / total);
            }
            globalEnvelope.expandToInclude(geomAndRow.geometry.getEnvelopeInternal());
        });
        DataTableSpec outputSpec = this.createOutputSpec(inputTable.getDataTableSpec());
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        container.addRowToTable((DataRow)new DefaultRow(new RowKey("global_envelope"), new DataCell[]{StringCell.StringCellFactory.create((String)globalEnvelope.toString()), IntCell.IntCellFactory.create((int)0), DoubleCell.DoubleCellFactory.create((double)globalEnvelope.getMinX()), DoubleCell.DoubleCellFactory.create((double)globalEnvelope.getMinY()), DoubleCell.DoubleCellFactory.create((double)globalEnvelope.getMaxX()), DoubleCell.DoubleCellFactory.create((double)globalEnvelope.getMaxY())}));
        container.close();
        return new BufferedDataTable[]{container.getTable()};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

