/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.write.write_to_kml;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.DataTableToGeotoolsMapper;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.IWarningWriter;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.NodeWarningWriter;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.kml.KML;
import org.geotools.kml.v22.KMLConfiguration;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.util.FileUtil;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WriteWKTToKMLNodeModel
extends NodeModel {
    private final SettingsModelString m_file = new SettingsModelString("filename", null);
    private final SettingsModelBoolean m_removeKMLnamespace = new SettingsModelBoolean("removeNamespace", true);
    private final SettingsModelBoolean m_useKML22 = new SettingsModelBoolean("useKMLv22", true);

    protected WriteWKTToKMLNodeModel() {
        super(1, 0);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        NodeWarningWriter warnings;
        block28: {
            URL url;
            BufferedDataTable inputPopulation = inData[0];
            if (inputPopulation.size() > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("sorry, we can not store more than 2147483647 with this node.");
            }
            if (!SpatialUtils.hasGeometry((DataTableSpec)inputPopulation.getDataTableSpec())) {
                throw new IllegalArgumentException("the input table contains no spatial data (no column named the_geom)");
            }
            if (!SpatialUtils.hasCRS((DataTableSpec)inputPopulation.getDataTableSpec())) {
                throw new IllegalArgumentException("the input table contains spatial data but no Coordinate Reference System");
            }
            boolean paramRemoveKMLnamespace = this.m_removeKMLnamespace.getBooleanValue();
            boolean zipResult = this.m_file.getStringValue().toLowerCase().endsWith(".kmz");
            try {
                url = FileUtil.toURL((String)this.m_file.getStringValue());
            }
            catch (MalformedURLException | InvalidPathException e2) {
                e2.printStackTrace();
                throw new InvalidSettingsException("unable to open URL " + this.m_file.getStringValue() + ": " + e2.getMessage());
            }
            File file = FileUtil.getFileFromURL((URL)url);
            exec.setMessage("encoding entities");
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.setName("entities");
            DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
            builder.setCRS((CoordinateReferenceSystem)crs);
            Class geomClassToBeStored = SpatialUtils.detectGeometryClassFromData((BufferedDataTable)inputPopulation, (String)"the_geom");
            builder.add("the_geom", geomClassToBeStored);
            warnings = new NodeWarningWriter(this.getLogger());
            List<DataTableToGeotoolsMapper> mappers = inputPopulation.getDataTableSpec().stream().filter(colspec -> !"the_geom".equals(colspec.getName())).map(colspec -> new DataTableToGeotoolsMapper((IWarningWriter)warnings, colspec)).collect(Collectors.toList());
            mappers.forEach(mapper -> mapper.addAttributeForSpec(builder));
            SimpleFeatureType type = builder.buildFeatureType();
            int idxColGeom = inputPopulation.getDataTableSpec().findColumnIndex("the_geom");
            GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
            WKTReader reader = new WKTReader(geomFactory);
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
            ArrayList<SimpleFeature> toStore = new ArrayList<SimpleFeature>((int)inputPopulation.size());
            try (CloseableRowIterator itRow = inputPopulation.iterator();){
                int currentRow = 0;
                while (itRow.hasNext()) {
                    DataRow row = itRow.next();
                    DataCell cellGeom = row.getCell(idxColGeom);
                    if (cellGeom.isMissing()) continue;
                    try {
                        Geometry geom = reader.read(cellGeom.toString());
                        featureBuilder.add((Object)geom);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                    int colId = 0;
                    int i = 0;
                    while (i < row.getNumCells()) {
                        if (i != idxColGeom) {
                            featureBuilder.add(((DataTableToGeotoolsMapper)mappers.get(colId++)).getValueNoNull(row.getCell(i)));
                        }
                        ++i;
                    }
                    SimpleFeature feature = featureBuilder.buildFeature(null);
                    toStore.add(feature);
                    if (currentRow % 10 == 0) {
                        exec.setProgress(0.4 * (double)currentRow / (double)inputPopulation.size(), "encoding entity " + currentRow);
                        exec.checkCanceled();
                    }
                    ++currentRow;
                }
                toStore.isEmpty();
                exec.setProgress(0.4);
            }
            exec.setMessage("storing entities");
            ListFeatureCollection featureCollection = new ListFeatureCollection(type, toStore);
            QName KMLspace = null;
            KMLConfiguration configurationEncoder = null;
            if (this.m_useKML22.getBooleanValue()) {
                KMLspace = org.geotools.kml.v22.KML.kml;
                configurationEncoder = new KMLConfiguration();
            } else {
                KMLspace = KML.kml;
                configurationEncoder = new org.geotools.kml.KMLConfiguration();
            }
            Encoder encoder = new Encoder((Configuration)configurationEncoder);
            encoder.setIndenting(true);
            exec.setProgress(0.5, "writing entities");
            OutputStream os = null;
            try {
                if (zipResult) {
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(file));
                    ZipEntry e = new ZipEntry("doc.kml");
                    zos.putNextEntry(e);
                    os = zos;
                } else {
                    os = new FileOutputStream(file);
                }
                if (paramRemoveKMLnamespace) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        encoder.encode((Object)featureCollection, KMLspace, (OutputStream)baos);
                        String out = baos.toString().replaceAll("kml:", "");
                        os.write(out.getBytes());
                        break block28;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                encoder.encode((Object)featureCollection, KMLspace, os);
            }
            finally {
                if (os != null) {
                    if (zipResult) {
                        ((ZipOutputStream)os).closeEntry();
                    }
                    os.close();
                }
            }
        }
        exec.setProgress(1.0);
        this.setWarningMessage(warnings.buildWarnings());
        return new BufferedDataTable[0];
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec specs = inSpecs[0];
        if (this.m_file.getStringValue() == null) {
            throw new IllegalArgumentException("No filename was provided");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)specs)) {
            throw new IllegalArgumentException("the input table contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)specs)) {
            throw new IllegalArgumentException("the input table contains spatial data but no Coordinate Reference System");
        }
        try {
            FileUtil.toURL((String)this.m_file.getStringValue());
        }
        catch (MalformedURLException | InvalidPathException e2) {
            e2.printStackTrace();
            throw new InvalidSettingsException("unable to open URL " + this.m_file.getStringValue() + ": " + e2.getMessage());
        }
        return new DataTableSpec[0];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_file.saveSettingsTo(settings);
        this.m_removeKMLnamespace.saveSettingsTo(settings);
        this.m_useKML22.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.loadSettingsFrom(settings);
        this.m_removeKMLnamespace.loadSettingsFrom(settings);
        this.m_useKML22.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.validateSettings(settings);
        this.m_removeKMLnamespace.validateSettings(settings);
        this.m_useKML22.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

