/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.read.read_from_shapefile.GeotoolsToDataTableMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public abstract class AbstractReadWKTFromDatastoreNodeModel
extends NodeModel {
    protected AbstractReadWKTFromDatastoreNodeModel() {
        super(0, 1);
    }

    protected AbstractReadWKTFromDatastoreNodeModel(int inputs) {
        super(inputs, 1);
    }

    public AbstractReadWKTFromDatastoreNodeModel(PortType[] portTypesInput) {
        super(portTypesInput, new PortType[]{BufferedDataTable.TYPE});
    }

    protected DataTableSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[1];
    }

    protected abstract DataStore openDataStore(PortObject[] var1, ExecutionContext var2) throws InvalidSettingsException;

    protected abstract String getSchemaName(DataStore var1) throws InvalidSettingsException;

    protected BufferedDataTable[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        SimpleFeatureType type;
        DataStore datastore = this.openDataStore(inObjects, exec);
        if (datastore.getTypeNames().length == 0) {
            throw new InvalidSettingsException("this database does not contain any schema");
        }
        String schemaName = this.getSchemaName(datastore);
        try {
            type = datastore.getSchema(schemaName);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to decode the schema " + schemaName + " from the file: " + e, e);
        }
        ArrayList descriptors = new ArrayList(type.getAttributeDescriptors());
        Map<AttributeDescriptor, GeotoolsToDataTableMapper> gtAttribute2mapper = descriptors.stream().collect(Collectors.toMap(ad -> ad, ad -> new GeotoolsToDataTableMapper(ad, type.getCoordinateReferenceSystem(), this.getLogger())));
        DataColumnSpec[] dataColSpecs = (DataColumnSpec[])descriptors.stream().map(d -> ((GeotoolsToDataTableMapper)gtAttribute2mapper.get(d)).getKnimeColumnSpec()).toArray(DataColumnSpec[]::new);
        DataTableSpec outputSpec = new DataTableSpec(dataColSpecs);
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        int total = datastore.getFeatureSource(schemaName).getFeatures().size();
        SimpleFeatureIterator itFeature = datastore.getFeatureSource(schemaName).getFeatures().features();
        int rowIdx = 0;
        while (itFeature.hasNext()) {
            SimpleFeature feature = (SimpleFeature)itFeature.next();
            int i = 0;
            DataCell[] cells = new DataCell[dataColSpecs.length];
            for (AttributeDescriptor gtAtt : descriptors) {
                Object gtVal = feature.getAttribute(gtAtt.getName());
                GeotoolsToDataTableMapper mapper = gtAttribute2mapper.get(gtAtt);
                cells[i++] = mapper.convert(gtVal);
            }
            container.addRowToTable((DataRow)new DefaultRow(new RowKey("Row " + rowIdx), cells));
            if (rowIdx % 10 == 0) {
                exec.checkCanceled();
                exec.setProgress((double)rowIdx / (double)total, "reading row " + rowIdx);
            }
            ++rowIdx;
        }
        itFeature.close();
        datastore.dispose();
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

