/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.properties.surface;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class SpatialPropertySurfaceNodeModel
extends NodeModel {
    private final SettingsModelString m_colname = new SettingsModelString("colname", "geom_surface");
    long done = 0L;

    protected SpatialPropertySurfaceNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (spec == null) {
            throw new InvalidSettingsException("no table as input");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec)) {
            throw new InvalidSettingsException("the input table contains no WKT geometry");
        }
        String colname = this.m_colname.getStringValue();
        if (spec.containsName(colname)) {
            throw new InvalidSettingsException("the table already contains a column named " + colname);
        }
        return new DataTableSpec[]{this.createOutputSpec(spec)};
    }

    private DataTableSpec createOutputSpec(DataTableSpec inputTableSpec) {
        String colname = this.m_colname.getStringValue();
        ArrayList<DataColumnSpec> newColumnSpecs = new ArrayList<DataColumnSpec>(inputTableSpec.getNumColumns() + 1);
        int i = 0;
        while (i < inputTableSpec.getNumColumns()) {
            newColumnSpecs.add(inputTableSpec.getColumnSpec(i));
            ++i;
        }
        newColumnSpecs.add(new DataColumnSpecCreator(colname, DoubleCell.TYPE).createSpec());
        return new DataTableSpec(newColumnSpecs.toArray(new DataColumnSpec[newColumnSpecs.size()]));
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        if (!ReferencingFactoryFinder.getAuthorityNames().contains("AUTO")) {
            throw new RuntimeException("No factory for autority AUTO");
        }
        BufferedDataTable inputTable = inData[0];
        DataTableSpec outputSpec = this.createOutputSpec(inputTable.getDataTableSpec());
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        double total = inputTable.size();
        int numberOfCells = inputTable.getDataTableSpec().getNumColumns();
        CoordinateReferenceSystem crsOrig = SpatialUtils.decodeCRS((DataTableSpec)inputTable.getDataTableSpec());
        CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"AUTO", null);
        this.done = 0L;
        SpatialUtils.applyToEachGeometry((BufferedDataTable)inputTable, geomAndRow -> {
            try {
                Geometry transformed = null;
                Point centroid = geomAndRow.geometry.getCentroid();
                ProjectedCRS crsTarget = factory.createProjectedCRS("AUTO:42001," + centroid.getX() + "," + centroid.getY());
                MathTransform transform2 = CRS.findMathTransform((CoordinateReferenceSystem)crsOrig, (CoordinateReferenceSystem)crsTarget, (boolean)true);
                transformed = JTS.transform((Geometry)geomAndRow.geometry, (MathTransform)transform2);
                double surfaceSquareMeter = transformed.getArea();
                DataCell[] cells = new DataCell[numberOfCells + 1];
                int i = 0;
                while (i < numberOfCells) {
                    cells[i] = geomAndRow.row.getCell(i);
                    ++i;
                }
                cells[n] = DoubleCell.DoubleCellFactory.create((double)surfaceSquareMeter);
                DefaultRow row = new DefaultRow(geomAndRow.row.getKey(), cells);
                container.addRowToTable((DataRow)row);
                if (this.done++ % 100L == 0L) {
                    exec.checkCanceled();
                    exec.setProgress((double)this.done / total, "computing surface of row " + this.done);
                }
            }
            catch (MismatchedDimensionException | FactoryException | TransformException e) {
                e.printStackTrace();
                throw new InvalidSettingsException("An error occured during the reprojection of geometries; please reproject your geometries first: " + e.getMessage());
            }
        });
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_colname.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

