/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.write.write_to_db;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.DataTableToGeotoolsMapper;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.IWarningWriter;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.NodeWarningWriter;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelPassword;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WriteWKTIntoDBNodeModel
extends NodeModel {
    static final String ENCRYPTION_KEY = "KnimeWKT";
    protected SettingsModelString m_dbtype = new SettingsModelString("dbtype", "postgis");
    protected SettingsModelString m_host = new SettingsModelString("host", "127.0.0.1");
    protected SettingsModelIntegerBounded m_port = new SettingsModelIntegerBounded("port", 5432, 1, 65535);
    protected SettingsModelString m_schema = new SettingsModelString("schema", "public");
    protected SettingsModelString m_database = new SettingsModelString("database", "database");
    protected SettingsModelString m_user = new SettingsModelString("user", "postgres");
    protected SettingsModelString m_password = new SettingsModelPassword("password", "KnimeWKT", "postgres");
    protected SettingsModelString m_layer = new SettingsModelString("layer", "my_geometries");
    protected SettingsModelBoolean m_checkWritten = new SettingsModelBoolean("check_written", true);
    static final int BUFFER = 5000;

    protected WriteWKTIntoDBNodeModel() {
        super(1, 0);
    }

    protected DataStore openDataStore(ExecutionContext exec) throws InvalidSettingsException {
        DataStore dataStore;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dbtype", this.m_dbtype.getStringValue());
        params.put("host", this.m_host.getStringValue());
        params.put("port", this.m_port.getIntValue());
        params.put("schema", this.m_schema.getStringValue());
        params.put("database", this.m_database.getStringValue());
        params.put("user", this.m_user.getStringValue());
        params.put("passwd", this.m_password.getStringValue());
        try {
            String dbg = "opening database: " + params.get("user") + "@" + params.get("host") + ":" + params.get("port");
            if (exec != null) {
                exec.setMessage(dbg);
            }
            this.getLogger().info((Object)dbg);
            dataStore = DataStoreFinder.getDataStore(params);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new InvalidSettingsException("Unable to open the url as a shape file: " + e1.getMessage());
        }
        return dataStore;
    }

    protected String getSchemaName(DataStore datastore) throws InvalidSettingsException {
        String layer = this.m_layer.getStringValue().trim();
        HashSet<String> typeNames = new HashSet<String>();
        try {
            typeNames.addAll(Arrays.asList(datastore.getTypeNames()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error when trying to read the layers: " + e.getMessage(), e);
        }
        return layer;
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        String layer = this.m_layer.getStringValue();
        if (layer == null) {
            throw new InvalidSettingsException("please select one layer to read");
        }
        if (inSpecs.length < 1) {
            throw new InvalidSettingsException("missing input table");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)inSpecs[0])) {
            throw new InvalidSettingsException("the input table contains no WKT geometry");
        }
        return new DataTableSpec[0];
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        DataStore datastore;
        NodeWarningWriter warnings;
        String layerName;
        BufferedDataTable inputPopulation;
        block37: {
            inputPopulation = inData[0];
            if (!SpatialUtils.hasGeometry((DataTableSpec)inputPopulation.getDataTableSpec())) {
                throw new IllegalArgumentException("the input table contains no spatial data (no column named the_geom)");
            }
            if (!SpatialUtils.hasCRS((DataTableSpec)inputPopulation.getDataTableSpec())) {
                throw new IllegalArgumentException("the input table contains spatial data but no Coordinate Reference System");
            }
            layerName = this.m_layer.getStringValue().trim();
            if (layerName.isEmpty()) {
                throw new IllegalArgumentException("please provide a layer name");
            }
            CoordinateReferenceSystem crsOrig = SpatialUtils.decodeCRS((DataTableSpec)inputPopulation.getSpec());
            warnings = new NodeWarningWriter(this.getLogger());
            datastore = this.openDataStore(exec);
            exec.setMessage("storing entities");
            SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
            builder.setName(layerName);
            builder.setCRS(crsOrig);
            Class geomClassToBeStored = SpatialUtils.detectGeometryClassFromData((BufferedDataTable)inputPopulation, (String)"the_geom");
            builder.add("geom", geomClassToBeStored);
            List<DataTableToGeotoolsMapper> mappers = inputPopulation.getDataTableSpec().stream().filter(colspec -> !"the_geom".equals(colspec.getName())).map(colspec -> new DataTableToGeotoolsMapper((IWarningWriter)warnings, colspec)).collect(Collectors.toList());
            mappers.forEach(mapper -> mapper.addAttributeForSpec(builder));
            SimpleFeatureType type = builder.buildFeatureType();
            try {
                datastore.getSchema(type.getName());
            }
            catch (IOException e) {
                datastore.createSchema((FeatureType)type);
            }
            SimpleFeatureSource featureSource = datastore.getFeatureSource(layerName);
            if (!(featureSource instanceof SimpleFeatureStore)) {
                throw new IllegalStateException("Modification not supported");
            }
            SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
            int idxColGeom = inputPopulation.getDataTableSpec().findColumnIndex("the_geom");
            GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
            WKTReader reader = new WKTReader(geomFactory);
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
            DefaultTransaction transaction = new DefaultTransaction();
            featureStore.setTransaction((Transaction)transaction);
            ArrayList<SimpleFeature> toStore = new ArrayList<SimpleFeature>(5000);
            CloseableRowIterator itRow = inputPopulation.iterator();
            try {
                try {
                    int currentRow = 0;
                    while (itRow.hasNext()) {
                        DataRow row = itRow.next();
                        DataCell cellGeom = row.getCell(idxColGeom);
                        if (cellGeom.isMissing()) continue;
                        try {
                            Geometry geom = reader.read(cellGeom.toString());
                            featureBuilder.add((Object)geom);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                            throw new RuntimeException(e);
                        }
                        int colId = 0;
                        int i = 0;
                        while (i < row.getNumCells()) {
                            if (i != idxColGeom) {
                                featureBuilder.add(((DataTableToGeotoolsMapper)mappers.get(colId++)).getValue(row.getCell(i)));
                            }
                            ++i;
                        }
                        SimpleFeature feature = featureBuilder.buildFeature(Integer.toString(currentRow));
                        if (!toStore.add(feature)) {
                            warnings.warn("unknown problem when adding feature, it will be missing : " + feature);
                        }
                        if (toStore.size() >= 5000) {
                            exec.checkCanceled();
                            exec.setMessage("writing " + toStore.size() + " entities");
                            featureStore.addFeatures((FeatureCollection)new ListFeatureCollection(type, toStore));
                            toStore.clear();
                            transaction = new DefaultTransaction();
                        }
                        if (currentRow % 10 == 0) {
                            exec.setProgress((double)currentRow / (double)inputPopulation.size(), "processing row " + currentRow);
                            exec.checkCanceled();
                        }
                        ++currentRow;
                    }
                    if (!toStore.isEmpty()) {
                        exec.setMessage("writing " + toStore.size() + " entities (final)");
                        featureStore.addFeatures((FeatureCollection)new ListFeatureCollection(type, toStore));
                    }
                    this.getLogger().info((Object)"commiting changes to database");
                    transaction.commit();
                    toStore.clear();
                    this.getLogger().info((Object)"done");
                    exec.setProgress(1.0);
                }
                catch (RuntimeException e) {
                    if (transaction != null) {
                        try {
                            this.getLogger().info((Object)"applying rollback to attempt remove our changes in the database");
                            transaction.rollback();
                        }
                        catch (IOException doubleEeek) {
                            this.getLogger().warn((Object)("error during rollback; maybe some garbage will remain in the database " + e.getMessage()));
                        }
                    }
                    if (transaction != null) {
                        transaction.close();
                    }
                    if (itRow != null) {
                        itRow.close();
                    }
                    datastore.dispose();
                    break block37;
                }
            }
            catch (Throwable throwable) {
                if (transaction != null) {
                    transaction.close();
                }
                if (itRow != null) {
                    itRow.close();
                }
                datastore.dispose();
                throw throwable;
            }
            if (transaction != null) {
                transaction.close();
            }
            if (itRow != null) {
                itRow.close();
            }
            datastore.dispose();
        }
        this.setWarningMessage(warnings.buildWarnings());
        if (this.m_checkWritten.getBooleanValue()) {
            DataStore datastoreRead = this.openDataStore(exec);
            try {
                if (datastore == datastoreRead) {
                    this.getLogger().warn((Object)"got the same datastore, cannot test...");
                } else {
                    exec.setMessage("checking the count of entities in the database");
                    SimpleFeatureSource featureSourceRead = datastoreRead.getFeatureSource(layerName);
                    SimpleFeatureCollection collectionRead = featureSourceRead.getFeatures();
                    if ((long)collectionRead.size() < inputPopulation.size()) {
                        throw new RuntimeException("we did not wrote the expected count of entities: there were " + inputPopulation.size() + " lines, but only " + collectionRead.size() + " features were created");
                    }
                }
            }
            finally {
                if (datastoreRead != null) {
                    datastoreRead.dispose();
                }
            }
        }
        return new BufferedDataTable[0];
    }

    protected void reset() {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_dbtype.saveSettingsTo(settings);
        this.m_host.saveSettingsTo(settings);
        this.m_port.saveSettingsTo(settings);
        this.m_schema.saveSettingsTo(settings);
        this.m_database.saveSettingsTo(settings);
        this.m_user.saveSettingsTo(settings);
        this.m_password.saveSettingsTo(settings);
        this.m_layer.saveSettingsTo(settings);
        this.m_checkWritten.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_dbtype.loadSettingsFrom(settings);
        this.m_host.loadSettingsFrom(settings);
        this.m_port.loadSettingsFrom(settings);
        this.m_schema.loadSettingsFrom(settings);
        this.m_database.loadSettingsFrom(settings);
        this.m_user.loadSettingsFrom(settings);
        this.m_password.loadSettingsFrom(settings);
        this.m_layer.loadSettingsFrom(settings);
        this.m_checkWritten.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_dbtype.validateSettings(settings);
        this.m_host.validateSettings(settings);
        this.m_port.validateSettings(settings);
        this.m_schema.validateSettings(settings);
        this.m_database.validateSettings(settings);
        this.m_user.validateSettings(settings);
        this.m_password.validateSettings(settings);
        this.m_layer.validateSettings(settings);
        this.m_checkWritten.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

