/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.create.pointfrom2d;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.referencing.CRS;
import org.knime.core.data.DataColumnProperties;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CreatePointFrom2DNodeModel
extends NodeModel {
    private final SettingsModelString m_colname_x = new SettingsModelString("colname_x", "X");
    private final SettingsModelString m_colname_y = new SettingsModelString("colname_y", "Y");
    private final SettingsModelBoolean m_delete_xy = new SettingsModelBoolean("delete_xy", Boolean.TRUE.booleanValue());
    private final SettingsModelString m_crs = new SettingsModelString("crs", SpatialUtils.getDefaultCRSString());

    protected CreatePointFrom2DNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (spec == null) {
            throw new InvalidSettingsException("no table as input");
        }
        if (spec.containsName("the_geom")) {
            throw new InvalidSettingsException("the input table already contains a column named the_geom");
        }
        if (!spec.containsName(this.m_colname_x.getStringValue())) {
            throw new InvalidSettingsException("unknown column " + this.m_colname_x.getStringValue() + " in the table");
        }
        if (!spec.containsName(this.m_colname_y.getStringValue())) {
            throw new InvalidSettingsException("unknown column " + this.m_colname_y.getStringValue() + " in the table");
        }
        double minX = ((DoubleValue)spec.getColumnSpec(this.m_colname_x.getStringValue()).getDomain().getLowerBound()).getDoubleValue();
        double maxX = ((DoubleValue)spec.getColumnSpec(this.m_colname_x.getStringValue()).getDomain().getUpperBound()).getDoubleValue();
        double minY = ((DoubleValue)spec.getColumnSpec(this.m_colname_y.getStringValue()).getDomain().getLowerBound()).getDoubleValue();
        double maxY = ((DoubleValue)spec.getColumnSpec(this.m_colname_y.getStringValue()).getDomain().getUpperBound()).getDoubleValue();
        CoordinateReferenceSystem crsTarget = SpatialUtils.getCRSforString((String)this.m_crs.getStringValue());
        Envelope env = CRS.getEnvelope((CoordinateReferenceSystem)crsTarget);
        double crsminX = env.getMinimum(0);
        double crsmaxX = env.getMaximum(0);
        double crsminY = env.getMinimum(1);
        double crsmaxY = env.getMaximum(1);
        LinkedList<String> pbs = new LinkedList<String>();
        if (minX < crsminX) {
            pbs.add("lower bound of X values " + minX + " is smaller than the minimum X coordinate " + crsminX);
        }
        if (maxX > crsmaxX) {
            pbs.add("upper bound of X values " + maxX + " is greater than the maximum Y coordinate " + crsmaxX);
        }
        if (minY < crsminY) {
            pbs.add("lower bound of Y values " + minY + " is smaller than the minimum Y coordinate " + crsminY);
        }
        if (maxY > crsmaxY) {
            pbs.add("upper bound of Y values " + maxY + " is greater than the maximum Y coordinate " + crsmaxY);
        }
        if (!pbs.isEmpty()) {
            throw new InvalidSettingsException("The X and Y values are not compatible with the Coordinate Reference System: " + String.join((CharSequence)", ", pbs));
        }
        return new DataTableSpec[]{this.createOutputSpec(spec)};
    }

    private DataTableSpec createOutputSpec(DataTableSpec inputTableSpec) {
        String colname_x = this.m_colname_x.getStringValue();
        String colname_y = this.m_colname_y.getStringValue();
        boolean delete_xy = this.m_delete_xy.getBooleanValue();
        CoordinateReferenceSystem crsTarget = SpatialUtils.getCRSforString((String)this.m_crs.getStringValue());
        ArrayList<DataColumnSpec> newColumnSpecs = new ArrayList<DataColumnSpec>(inputTableSpec.getNumColumns() + 1);
        int i = 0;
        while (i < inputTableSpec.getNumColumns()) {
            String name = inputTableSpec.getColumnNames()[i];
            if (!delete_xy || !colname_x.equals(name) && !colname_y.equals(name)) {
                newColumnSpecs.add(inputTableSpec.getColumnSpec(i));
            }
            ++i;
        }
        HashMap<String, String> properties = new HashMap<String, String>(inputTableSpec.getProperties());
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)crsTarget));
        properties.put("crs WKT", crsTarget.toWKT());
        DataColumnSpecCreator creator = new DataColumnSpecCreator("the_geom", StringCell.TYPE);
        creator.setProperties(new DataColumnProperties(properties));
        newColumnSpecs.add(creator.createSpec());
        return new DataTableSpec(newColumnSpecs.toArray(new DataColumnSpec[newColumnSpecs.size()]));
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inputTable = inData[0];
        DataTableSpec outputSpec = this.createOutputSpec(inputTable.getDataTableSpec());
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        boolean delete_xy = this.m_delete_xy.getBooleanValue();
        int idxColumnX = inputTable.getSpec().findColumnIndex(this.m_colname_x.getStringValue());
        int idxColumnY = inputTable.getSpec().findColumnIndex(this.m_colname_y.getStringValue());
        GeometryFactory gf = new GeometryFactory();
        CloseableRowIterator itRow = inputTable.iterator();
        while (itRow.hasNext()) {
            DataRow row = itRow.next();
            List cells = null;
            if (delete_xy) {
                cells = new ArrayList(row.getNumCells() - 1);
                int i = 0;
                while (i < row.getNumCells()) {
                    if (i != idxColumnX && i != idxColumnY) {
                        cells.add(row.getCell(i));
                    }
                    ++i;
                }
            } else {
                cells = row.stream().collect(Collectors.toList());
            }
            double x = ((DoubleValue)row.getCell(idxColumnX)).getDoubleValue();
            double y = ((DoubleValue)row.getCell(idxColumnY)).getDoubleValue();
            Point point = gf.createPoint(new Coordinate(x, y));
            cells.add(StringCell.StringCellFactory.create((String)point.toString()));
            container.addRowToTable((DataRow)new DefaultRow(row.getKey(), cells));
        }
        itRow.close();
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_colname_x.saveSettingsTo(settings);
        this.m_colname_y.saveSettingsTo(settings);
        this.m_crs.saveSettingsTo(settings);
        this.m_delete_xy.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname_x.loadSettingsFrom(settings);
        this.m_colname_y.loadSettingsFrom(settings);
        this.m_crs.loadSettingsFrom(settings);
        this.m_delete_xy.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname_x.validateSettings(settings);
        this.m_colname_y.validateSettings(settings);
        this.m_crs.validateSettings(settings);
        this.m_delete_xy.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

