/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.view;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.awt.Color;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataStore;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelColor;
import org.knime.core.node.defaultnodesettings.SettingsModelDoubleBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortType;
import org.knime.core.util.FileUtil;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DisplaySpatialPopulationNodeModel
extends NodeModel {
    protected DataStore datastore1 = null;
    protected File tmpFile1 = null;
    protected DataStore datastore2 = null;
    protected File tmpFile2 = null;
    protected SettingsModelColor m_color1 = new SettingsModelColor("color1", Color.GRAY);
    protected SettingsModelColor m_color2 = new SettingsModelColor("color2", Color.BLUE);
    protected SettingsModelDoubleBounded m_opacity1 = new SettingsModelDoubleBounded("opacity1", 0.5, 0.0, 1.0);
    protected SettingsModelDoubleBounded m_opacity2 = new SettingsModelDoubleBounded("opacity2", 0.7, 0.0, 1.0);
    protected SettingsModelString m_urlWMS = new SettingsModelString("url wms", "https://ows.terrestris.de/osm-gray/service");

    protected DisplaySpatialPopulationNodeModel() {
        super(new PortType[]{BufferedDataTable.TYPE, BufferedDataTable.TYPE_OPTIONAL}, new PortType[0]);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        this.datastore1 = null;
        this.datastore2 = null;
        BufferedDataTable inputPopulation1 = inData[0];
        BufferedDataTable inputPopulation2 = inData[1];
        long total1 = inputPopulation1.size();
        long total2 = inputPopulation2 != null ? inputPopulation2.size() : 0L;
        double totaltotal = total1 + total2;
        ExecutionMonitor progress1 = exec.createSubProgress((double)total1 / totaltotal);
        ExecutionMonitor progress2 = exec.createSubProgress((double)total2 / totaltotal);
        if (!SpatialUtils.hasGeometry((DataTableSpec)inputPopulation1.getDataTableSpec())) {
            throw new IllegalArgumentException("the input table 1 contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)inputPopulation1.getDataTableSpec())) {
            throw new IllegalArgumentException("the input table 1 contains spatial data but no Coordinate Reference System");
        }
        if (inputPopulation2 != null) {
            if (!SpatialUtils.hasGeometry((DataTableSpec)inputPopulation2.getDataTableSpec())) {
                throw new IllegalArgumentException("the input table 2 contains no spatial data (no column named the_geom)");
            }
            if (!SpatialUtils.hasCRS((DataTableSpec)inputPopulation2.getDataTableSpec())) {
                throw new IllegalArgumentException("the input table 2 contains spatial data but no Coordinate Reference System");
            }
        }
        CoordinateReferenceSystem crsOrig1 = SpatialUtils.decodeCRS((DataTableSpec)inputPopulation1.getSpec());
        this.tmpFile1 = FileUtil.createTempFile((String)"shapefile", (String)".shp");
        this.datastore1 = SpatialUtils.createDataStore((File)this.tmpFile1, (boolean)false);
        Runnable runnableSpatialize1 = SpatialUtils.decodeAsFeaturesRunnable((BufferedDataTable)inputPopulation1, (String)"the_geom", (ExecutionMonitor)progress1, (DataStore)this.datastore1, (String)"entities1", (CoordinateReferenceSystem)crsOrig1, (boolean)false, (Color)this.m_color1.getColorValue());
        exec.setMessage("storing entities");
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(runnableSpatialize1);
        if (inputPopulation2 != null) {
            CoordinateReferenceSystem crsOrig2 = SpatialUtils.decodeCRS((DataTableSpec)inputPopulation2.getSpec());
            this.tmpFile2 = FileUtil.createTempFile((String)"shapefile", (String)".shp");
            this.datastore2 = SpatialUtils.createDataStore((File)this.tmpFile2, (boolean)false);
            Runnable runnableSpatialize2 = SpatialUtils.decodeAsFeaturesRunnable((BufferedDataTable)inputPopulation2, (String)"the_geom", (ExecutionMonitor)progress2, (DataStore)this.datastore2, (String)"entities2", (CoordinateReferenceSystem)crsOrig2, (boolean)false, (Color)this.m_color2.getColorValue());
            executor.execute(runnableSpatialize2);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return new BufferedDataTable[0];
    }

    protected void reset() {
        this.disposeDatastores();
    }

    protected void disposeDatastores() {
        if (this.datastore1 != null) {
            this.datastore1.dispose();
        }
        if (this.datastore2 != null) {
            this.datastore2.dispose();
        }
    }

    protected void onDispose() {
        this.disposeDatastores();
        super.onDispose();
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[0];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_color1.saveSettingsTo(settings);
        this.m_color2.saveSettingsTo(settings);
        this.m_opacity1.saveSettingsTo(settings);
        this.m_opacity2.saveSettingsTo(settings);
        this.m_urlWMS.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_color1.loadSettingsFrom(settings);
        this.m_color2.loadSettingsFrom(settings);
        this.m_opacity1.loadSettingsFrom(settings);
        this.m_opacity2.loadSettingsFrom(settings);
        this.m_urlWMS.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_color1.validateSettings(settings);
        this.m_color2.validateSettings(settings);
        this.m_opacity1.validateSettings(settings);
        this.m_opacity2.validateSettings(settings);
        this.m_urlWMS.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        File bckp = new File(internDir, "datastore1");
        if (!(bckp.exists() && bckp.canRead() && bckp.isDirectory())) {
            return;
        }
        this.getLogger().debug((Object)("restoring datastore from " + bckp));
        this.tmpFile1 = new File(bckp, "shapefile.shp");
        if (!(this.tmpFile1.exists() && this.tmpFile1.canRead() && this.tmpFile1.isFile())) {
            return;
        }
        this.datastore1 = SpatialUtils.createDataStore((File)this.tmpFile1, (boolean)false);
        bckp = new File(internDir, "datastore2");
        if (!(bckp.exists() && bckp.canRead() && bckp.isDirectory())) {
            return;
        }
        this.getLogger().debug((Object)("restoring datastore from " + bckp));
        this.tmpFile2 = new File(bckp, "shapefile.shp");
        if (!(this.tmpFile2.exists() && this.tmpFile2.canRead() && this.tmpFile2.isFile())) {
            return;
        }
        this.datastore2 = SpatialUtils.createDataStore((File)this.tmpFile2, (boolean)false);
    }

    protected void copyAllShapefileFiles(File fileShp, File targetDirectory, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        targetDirectory.mkdirs();
        String filenameBase = FilenameUtils.removeExtension((String)fileShp.getName());
        File origDirectory = fileShp.getParentFile();
        File[] filesToCopy = origDirectory.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        double progress = 1.0 / (double)filesToCopy.length;
        File[] fileArray = filesToCopy;
        int n = filesToCopy.length;
        int n2 = 0;
        while (n2 < n) {
            File fileToCopy = fileArray[n2];
            String extension = FilenameUtils.getExtension((String)fileToCopy.getName());
            FileUtil.copy((File)fileToCopy, (File)new File(targetDirectory, "shapefile." + extension), (ExecutionMonitor)exec.createSilentSubProgress(progress));
            ++n2;
        }
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
        if (this.datastore1 != null) {
            File dir1 = new File(internDir, "datastore1");
            this.copyAllShapefileFiles(this.tmpFile1, dir1, exec.createSilentSubProgress(0.5));
        }
        if (this.datastore2 != null) {
            File dir2 = new File(internDir, "datastore2");
            this.copyAllShapefileFiles(this.tmpFile2, dir2, exec.createSilentSubProgress(0.5));
        }
    }
}

