/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.transform.reproject;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnProperties;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class ReprojectNodeModel
extends NodeModel {
    public static final String MODEL_KEY_CRS = "crs";
    private final SettingsModelString m_crs = new SettingsModelString("crs", SpatialUtils.getDefaultCRSString());
    long done = 0L;

    protected ReprojectNodeModel() {
        super(1, 1);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inputPopulation = inData[0];
        if (!SpatialUtils.hasGeometry((DataTableSpec)inputPopulation.getDataTableSpec())) {
            throw new InvalidSettingsException("the input table contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)inputPopulation.getDataTableSpec())) {
            throw new InvalidSettingsException("the input table contains spatial data but no Coordinate Reference System");
        }
        int idxColumnGeom = inputPopulation.getSpec().findColumnIndex("the_geom");
        CoordinateReferenceSystem crsOrig = SpatialUtils.decodeCRS((DataTableSpec)inputPopulation.getSpec());
        CoordinateReferenceSystem crsTarget = SpatialUtils.getCRSforString((String)this.m_crs.getStringValue());
        exec.setMessage("creating specifications");
        DataColumnSpec[] novelsSpecs = new DataColumnSpec[inputPopulation.getDataTableSpec().getNumColumns()];
        int i = 0;
        while (i < idxColumnGeom) {
            novelsSpecs[i] = inputPopulation.getDataTableSpec().getColumnSpec(i);
            ++i;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)crsTarget));
        properties.put("crs WKT", crsTarget.toWKT());
        DataColumnSpecCreator creator = new DataColumnSpecCreator(inputPopulation.getDataTableSpec().getColumnSpec(idxColumnGeom).getName(), StringCell.TYPE);
        creator.setProperties(new DataColumnProperties(properties));
        novelsSpecs[idxColumnGeom] = creator.createSpec();
        int i2 = idxColumnGeom + 1;
        while (i2 < novelsSpecs.length) {
            novelsSpecs[i2] = inputPopulation.getDataTableSpec().getColumnSpec(i2);
            ++i2;
        }
        DataTableSpec novelSpec = new DataTableSpec("spatial entities", novelsSpecs);
        BufferedDataContainer container = exec.createDataContainer(novelSpec);
        int colCount = novelSpec.getNumColumns();
        this.done = 0L;
        double total = inputPopulation.size();
        MathTransform transform = null;
        try {
            transform = CRS.findMathTransform((CoordinateReferenceSystem)crsOrig, (CoordinateReferenceSystem)crsTarget, (boolean)false);
        }
        catch (OperationNotFoundException e) {
            e.printStackTrace();
            this.setWarningMessage("unable to find a math transform without being lenient; the result will be a bit approximated (" + e.getLocalizedMessage() + ")");
            transform = CRS.findMathTransform((CoordinateReferenceSystem)crsOrig, (CoordinateReferenceSystem)crsTarget, (boolean)true);
        }
        MathTransform transform2 = transform;
        SpatialUtils.applyToEachGeometry((BufferedDataTable)inputPopulation, geomAndRow -> {
            ArrayList<DataCell> cells = new ArrayList<DataCell>();
            int i = 0;
            while (i < colCount) {
                if (i == idxColumnGeom) {
                    Geometry projected;
                    try {
                        projected = JTS.transform((Geometry)geomAndRow.geometry, (MathTransform)transform2);
                    }
                    catch (MismatchedDimensionException | TransformException e) {
                        e.printStackTrace();
                        throw new InvalidSettingsException("unable to reproject: " + e.getMessage());
                    }
                    cells.add(StringCell.StringCellFactory.create((String)projected.toString()));
                } else {
                    cells.add(geomAndRow.row.getCell(i));
                }
                ++i;
            }
            DefaultRow row = new DefaultRow(geomAndRow.row.getKey(), cells);
            container.addRowToTable((DataRow)row);
            if (this.done++ % 10L == 0L) {
                exec.checkCanceled();
                exec.setProgress((double)this.done / total, "computing surface of row " + this.done);
            }
        });
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void reset() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        int idxColumnGeom = inSpecs[0].findColumnIndex("the_geom");
        CoordinateReferenceSystem crsTarget = SpatialUtils.getCRSforString((String)this.m_crs.getStringValue());
        DataColumnSpec[] novelsSpecs = new DataColumnSpec[inSpecs[0].getNumColumns()];
        int i = 0;
        while (i < idxColumnGeom) {
            novelsSpecs[i] = inSpecs[0].getColumnSpec(i);
            ++i;
        }
        HashMap<String, String> properties = new HashMap<String, String>(inSpecs[0].getProperties());
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)crsTarget));
        properties.put("crs WKT", crsTarget.toWKT());
        DataColumnSpecCreator creator = new DataColumnSpecCreator(inSpecs[0].getColumnSpec(idxColumnGeom).getName(), StringCell.TYPE);
        creator.setProperties(new DataColumnProperties(properties));
        novelsSpecs[idxColumnGeom] = creator.createSpec();
        int i2 = idxColumnGeom + 1;
        while (i2 < novelsSpecs.length) {
            novelsSpecs[i2] = inSpecs[0].getColumnSpec(i2);
            ++i2;
        }
        return new DataTableSpec[]{new DataTableSpec("recoded", novelsSpecs)};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_crs.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_crs.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_crs.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

