/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.transform.operations;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.transform.operations.OperationsWKTGeometriesNodeModel;
import java.io.File;
import java.io.IOException;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.locationtech.jts.io.WKTWriter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OperationsWKTGeometriesNodeModel
extends NodeModel {
    private SettingsModelString m_relationship = new SettingsModelString("operation", "union");
    private SettingsModelString m_colname = new SettingsModelString("colname", "result");
    long done = 0L;

    protected OperationsWKTGeometriesNodeModel() {
        super(2, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        CoordinateReferenceSystem crs2;
        DataTableSpec spec1 = inSpecs[0];
        if (spec1 == null) {
            throw new InvalidSettingsException("no top table as input");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec1)) {
            throw new InvalidSettingsException("the top input table contains no WKT geometry");
        }
        DataTableSpec spec2 = inSpecs[0];
        if (spec2 == null) {
            throw new InvalidSettingsException("no bottom table as input");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec2)) {
            throw new InvalidSettingsException("the bottom input table contains no WKT geometry");
        }
        CoordinateReferenceSystem crs1 = SpatialUtils.decodeCRS((DataTableSpec)spec1);
        if (!crs1.equals(crs2 = SpatialUtils.decodeCRS((DataTableSpec)spec2))) {
            throw new InvalidSettingsException("the two tables are not spatialized on the same Coordinate Reference Sytems; please reproject them first");
        }
        return new DataTableSpec[]{spec1};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        if (!ReferencingFactoryFinder.getAuthorityNames().contains("AUTO")) {
            throw new RuntimeException("No factory for autority AUTO");
        }
        BufferedDataTable inputTable1 = inData[0];
        BufferedDataTable inputTable2 = inData[1];
        if (inputTable1.size() != inputTable2.size()) {
            throw new InvalidSettingsException("the two tables should have the same number of rows");
        }
        DataTableSpec outputSpec = inputTable1.getDataTableSpec();
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        double total = inputTable1.size();
        int numberOfCells = inputTable1.getDataTableSpec().getNumColumns();
        int idxGeom = inputTable1.getSpec().findColumnIndex("the_geom");
        String operation = this.m_relationship.getStringValue();
        DifferenceComputer computer = null;
        if (operation.equals("difference")) {
            computer = new DifferenceComputer(null);
        } else if (operation.equals("intersection")) {
            computer = new IntersectionComputer(null);
        } else if (operation.equals("union")) {
            computer = new UnionComputer(null);
        } else {
            throw new RuntimeException("Unknown operation: " + operation);
        }
        DifferenceComputer operationFinal = computer;
        WKTWriter writer = new WKTWriter();
        this.done = 0L;
        SpatialUtils.applyToEachGeometry((BufferedDataTable)inputTable1, (BufferedDataTable)inputTable2, arg_0 -> this.lambda$0(numberOfCells, idxGeom, writer, (IOperationComputer)operationFinal, container, exec, total, operation, arg_0));
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_relationship.saveSettingsTo(settings);
        this.m_colname.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_relationship.loadSettingsFrom(settings);
        this.m_colname.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_relationship.validateSettings(settings);
        this.m_colname.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }

    private /* synthetic */ void lambda$0(int n, int n2, WKTWriter wKTWriter, IOperationComputer iOperationComputer, BufferedDataContainer bufferedDataContainer, ExecutionContext executionContext, double d, String string, SpatialUtils.RowsAndGeometrys geomsAndRows) throws CanceledExecutionException, InvalidSettingsException {
        DataCell[] cells = new DataCell[n];
        int i = 0;
        while (i < n2) {
            cells[i] = geomsAndRows.row1.getCell(i);
            ++i;
        }
        cells[n2] = StringCell.StringCellFactory.create((String)wKTWriter.write(iOperationComputer.compute(geomsAndRows.geometry1, geomsAndRows.geometry2)));
        i = n2 + 1;
        while (i < n) {
            cells[i] = geomsAndRows.row1.getCell(i);
            ++i;
        }
        DefaultRow row = new DefaultRow(geomsAndRows.row1.getKey(), cells);
        bufferedDataContainer.addRowToTable((DataRow)row);
        executionContext.checkCanceled();
        executionContext.setProgress((double)this.done++ / d, "computing " + string + " of rows " + this.done);
    }
}

