/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.read.read_from_db;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.AbstractReadWKTFromDatastoreNodeModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.knime.core.data.DataTableSpec;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelPassword;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.util.CheckUtils;

public class ReadWKTFromDatabaseNodeModel
extends AbstractReadWKTFromDatastoreNodeModel {
    static final String ENCRYPTION_KEY = "KnimeWKT";
    protected SettingsModelString m_dbtype = new SettingsModelString("dbtype", "postgis");
    protected SettingsModelString m_host = new SettingsModelString("host", "127.0.0.1");
    protected SettingsModelIntegerBounded m_port = new SettingsModelIntegerBounded("port", 5432, 1, 65535);
    protected SettingsModelString m_schema = new SettingsModelString("schema", "public");
    protected SettingsModelString m_database = new SettingsModelString("database", "database");
    protected SettingsModelString m_user = new SettingsModelString("user", "postgres");
    protected SettingsModelString m_password = new SettingsModelPassword("password", "KnimeWKT", "postgres");
    protected SettingsModelString m_layer = new SettingsModelString("layer", null);

    protected ReadWKTFromDatabaseNodeModel() {
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        String layer = this.m_layer.getStringValue();
        if (layer == null) {
            throw new InvalidSettingsException("please select one layer to read");
        }
        String dbtype = this.m_dbtype.getStringValue();
        String database = this.m_database.getStringValue();
        if (dbtype.equals("h2") || dbtype.equals("geopkg")) {
            CheckUtils.checkSourceFile((String)database);
        }
        return super.configure(inSpecs);
    }

    protected DataStore openDataStore(PortObject[] inObjects, ExecutionContext exec) throws InvalidSettingsException {
        DataStore dataStore;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dbtype", this.m_dbtype.getStringValue());
        params.put("host", this.m_host.getStringValue());
        params.put("port", this.m_port.getIntValue());
        params.put("schema", this.m_schema.getStringValue());
        params.put("database", this.m_database.getStringValue());
        params.put("user", this.m_user.getStringValue());
        params.put("passwd", this.m_password.getStringValue());
        try {
            String dbg = "opening database: " + params.get("user") + "@" + params.get("host") + ":" + params.get("port");
            if (exec != null) {
                exec.setMessage(dbg);
            }
            this.getLogger().info((Object)dbg);
            dataStore = DataStoreFinder.getDataStore(params);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new InvalidSettingsException("Unable to open the url as a shape file: " + e1.getMessage());
        }
        return dataStore;
    }

    protected String getSchemaName(DataStore datastore) throws InvalidSettingsException {
        String layer = this.m_layer.getStringValue();
        HashSet<String> typeNames = new HashSet<String>();
        try {
            typeNames.addAll(Arrays.asList(datastore.getTypeNames()));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error when trying to read the layers: " + e.getMessage(), e);
        }
        if (!typeNames.contains(layer)) {
            throw new InvalidSettingsException("There is no layer named \"" + layer + "\" in this datastore");
        }
        return layer;
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_dbtype.saveSettingsTo(settings);
        this.m_host.saveSettingsTo(settings);
        this.m_port.saveSettingsTo(settings);
        this.m_schema.saveSettingsTo(settings);
        this.m_database.saveSettingsTo(settings);
        this.m_user.saveSettingsTo(settings);
        this.m_password.saveSettingsTo(settings);
        this.m_layer.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_dbtype.loadSettingsFrom(settings);
        this.m_host.loadSettingsFrom(settings);
        this.m_port.loadSettingsFrom(settings);
        this.m_schema.loadSettingsFrom(settings);
        this.m_database.loadSettingsFrom(settings);
        this.m_user.loadSettingsFrom(settings);
        this.m_password.loadSettingsFrom(settings);
        this.m_layer.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_dbtype.validateSettings(settings);
        this.m_host.validateSettings(settings);
        this.m_port.validateSettings(settings);
        this.m_schema.validateSettings(settings);
        this.m_database.validateSettings(settings);
        this.m_user.validateSettings(settings);
        this.m_password.validateSettings(settings);
        this.m_layer.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

