/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NotConfigurableException;
import org.knime.core.node.defaultnodesettings.DialogComponent;
import org.knime.core.node.defaultnodesettings.SettingsModel;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.util.DefaultStringIconOption;
import org.knime.core.node.util.StringIconListCellRenderer;
import org.knime.core.node.util.StringIconOption;

public class DialogComponentEncodingSelection
extends DialogComponent {
    public static final String CHOICE_AUTOMATIC = "<automatic>";
    private final JComboBox<StringIconOption> m_combobox;
    private final JLabel m_label = new JLabel("encoding");

    public DialogComponentEncodingSelection(SettingsModelString stringModel, boolean automaticEnabled) {
        super((SettingsModel)stringModel);
        this.getComponentPanel().add(this.m_label);
        this.m_combobox = new JComboBox();
        this.m_combobox.setRenderer(new StringIconListCellRenderer());
        ArrayList<DefaultStringIconOption> options = new ArrayList<DefaultStringIconOption>();
        int currentIdx = 0;
        if (automaticEnabled) {
            options.add(new DefaultStringIconOption(CHOICE_AUTOMATIC));
            ++currentIdx;
        }
        int defaultCharsetIdx = 0;
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        String defaultCharset = Charset.defaultCharset().name();
        for (String string : charsets.keySet()) {
            options.add(new DefaultStringIconOption(string));
            if (defaultCharset.equals(string)) {
                defaultCharsetIdx = currentIdx;
            }
            ++currentIdx;
        }
        for (StringIconOption stringIconOption : options) {
            this.m_combobox.addItem(stringIconOption);
        }
        this.m_combobox.setEditable(false);
        this.m_combobox.setSelectedIndex(defaultCharsetIdx);
        this.getComponentPanel().add(this.m_combobox);
        this.m_combobox.addItemListener((ItemListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getModel().addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.updateComponent();
    }

    protected void updateComponent() {
        boolean update;
        String strVal = ((SettingsModelString)this.getModel()).getStringValue();
        Object val = null;
        if (strVal == null) {
            val = null;
        } else {
            int i = 0;
            int length = this.m_combobox.getItemCount();
            while (i < length) {
                StringIconOption curVal = (StringIconOption)this.m_combobox.getItemAt(i);
                if (curVal.getText().equals(strVal)) {
                    val = curVal;
                    break;
                }
                ++i;
            }
            if (val == null) {
                val = new DefaultStringIconOption(strVal);
            }
        }
        if (val == null) {
            update = this.m_combobox.getSelectedItem() != null;
        } else {
            boolean bl = update = !val.equals(this.m_combobox.getSelectedItem());
        }
        if (update) {
            this.m_combobox.setSelectedItem(val);
        }
        this.setEnabledComponents(this.getModel().isEnabled());
        StringIconOption selItem = (StringIconOption)this.m_combobox.getSelectedItem();
        try {
            if (selItem == null && strVal != null || selItem != null && !selItem.getText().equals(strVal)) {
                this.updateModel();
            }
        }
        catch (InvalidSettingsException invalidSettingsException) {
            // empty catch block
        }
    }

    private void updateModel() throws InvalidSettingsException {
        if (this.m_combobox.getSelectedItem() == null) {
            ((SettingsModelString)this.getModel()).setStringValue(null);
            this.m_combobox.setBackground(Color.RED);
            this.m_combobox.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
            throw new InvalidSettingsException("Please select an item from the list.");
        }
        ((SettingsModelString)this.getModel()).setStringValue(((StringIconOption)this.m_combobox.getSelectedItem()).getText());
    }

    protected void validateSettingsBeforeSave() throws InvalidSettingsException {
        this.updateModel();
    }

    protected void checkConfigurabilityBeforeLoad(PortObjectSpec[] specs) throws NotConfigurableException {
    }

    protected void setEnabledComponents(boolean enabled) {
        this.m_combobox.setEnabled(enabled);
    }

    public void setToolTipText(String text) {
        this.m_label.setToolTipText(text);
        this.m_combobox.setToolTipText(text);
    }

    public void setSizeComponents(int width, int height) {
        this.m_combobox.setPreferredSize(new Dimension(width, height));
    }

    public void replaceListItems(Collection<String> newItems, String select) {
        if (newItems == null || newItems.size() < 1) {
            throw new NullPointerException("The container with the new items can't be null or empty.");
        }
        StringIconOption[] options = DefaultStringIconOption.createOptionArray(newItems);
        this.replaceListItems(options, select);
    }

    public void replaceListItems(StringIconOption[] newItems, String select) {
        if (newItems == null || newItems.length < 1) {
            throw new NullPointerException("The container with the new items can't be null or empty.");
        }
        String sel = select == null ? ((SettingsModelString)this.getModel()).getStringValue() : select;
        this.m_combobox.removeAllItems();
        StringIconOption selOption = null;
        StringIconOption[] stringIconOptionArray = newItems;
        int n = newItems.length;
        int n2 = 0;
        while (n2 < n) {
            StringIconOption option = stringIconOptionArray[n2];
            if (option == null) {
                throw new NullPointerException("Options in the selection list can't be null");
            }
            this.m_combobox.addItem(option);
            if (option.getText().equals(sel)) {
                selOption = option;
            }
            ++n2;
        }
        if (selOption == null) {
            this.m_combobox.setSelectedIndex(0);
        } else {
            this.m_combobox.setSelectedItem(selOption);
        }
        this.m_combobox.setSize(this.m_combobox.getPreferredSize());
        this.getComponentPanel().validate();
    }

    static /* synthetic */ void access$0(DialogComponentEncodingSelection dialogComponentEncodingSelection) throws InvalidSettingsException {
        dialogComponentEncodingSelection.updateModel();
    }

    static /* synthetic */ JComboBox access$1(DialogComponentEncodingSelection dialogComponentEncodingSelection) {
        return dialogComponentEncodingSelection.m_combobox;
    }

    static /* synthetic */ Color access$2() {
        return DEFAULT_BG;
    }
}

