/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.view;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.view.DisplaySpatialPopulationNodeModel;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.view.DisplaySpatialPopulationNodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.MapContent;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.ows.wms.WMSUtils;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.map.WMSLayer;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.swing.JMapPane;
import org.geotools.swing.MapPane;
import org.geotools.swing.action.InfoAction;
import org.geotools.swing.action.NoToolAction;
import org.geotools.swing.action.PanAction;
import org.geotools.swing.action.ZoomInAction;
import org.geotools.swing.action.ZoomOutAction;
import org.geotools.swing.event.MapMouseListener;
import org.geotools.swing.event.MapPaneListener;
import org.geotools.swing.tool.InfoTool;
import org.geotools.swing.tool.PanTool;
import org.geotools.swing.tool.ScrollWheelTool;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeView;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class DisplaySpatialPopulationNodeView
extends NodeView<DisplaySpatialPopulationNodeModel> {
    private static final NodeLogger logger = NodeLogger.getLogger(DisplaySpatialPopulationNodeView.class);
    private MapContent content = new MapContent();
    private JMapPane mapPane = null;
    private ReferencedEnvelope envelope = null;
    private List<WMSLayer> overlays = null;

    protected DisplaySpatialPopulationNodeView(DisplaySpatialPopulationNodeModel nodeModel) {
        super((NodeModel)nodeModel);
        StreamingRenderer renderer = new StreamingRenderer();
        this.mapPane = new JMapPane(this.content);
        this.mapPane.setRenderer((GTRenderer)renderer);
        this.mapPane.addMouseListener((MapMouseListener)new ScrollWheelTool(this.mapPane));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.mapPane.setPreferredSize(new Dimension(screenSize.width * 2 / 3, screenSize.height * 2 / 3));
        this.setComponent((Component)this.mapPane);
        try {
            JMenuBar menuBar = this.getJMenuBar();
            ButtonGroup group = new ButtonGroup();
            JMenu menu = new JMenu("Spatial tools");
            menu.setMnemonic('S');
            JMenuItem resetMenu = new JMenuItem("Zoom to fit");
            1 a = new /* Unavailable Anonymous Inner Class!! */;
            resetMenu.setIcon((Icon)a.getValue("SmallIcon"));
            resetMenu.addActionListener((ActionListener)a);
            menu.add(resetMenu);
            menu.addSeparator();
            JRadioButtonMenuItem noToolMenu = new JRadioButtonMenuItem(NoToolAction.TOOL_NAME);
            a = new NoToolAction((MapPane)this.mapPane);
            group.add(noToolMenu);
            noToolMenu.setSelected(true);
            noToolMenu.setIcon((Icon)a.getValue("SmallIcon"));
            noToolMenu.addActionListener((ActionListener)a);
            menu.add(noToolMenu);
            JRadioButtonMenuItem panMenu = new JRadioButtonMenuItem(PanTool.TOOL_NAME);
            group.add(panMenu);
            try {
                panMenu.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/org/geotools/swing/icons/mActionPan.png"))));
            }
            catch (IOException e) {
                logger.error((Object)"unable to load image resource /org/geotools/swing/icons/mActionPan.png", (Throwable)e);
                e.printStackTrace();
            }
            panMenu.setMnemonic('P');
            panMenu.addActionListener((ActionListener)new PanAction((MapPane)this.mapPane));
            menu.add(panMenu);
            JRadioButtonMenuItem infoMenu = new JRadioButtonMenuItem(InfoTool.TOOL_NAME);
            group.add(infoMenu);
            try {
                infoMenu.setIcon(new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/org/geotools/swing/icons/mActionIdentify.png"))));
            }
            catch (IOException e) {
                logger.error((Object)"unable to load image resource /org/geotools/swing/icons/mActionIdentify.png", (Throwable)e);
                e.printStackTrace();
            }
            infoMenu.addActionListener((ActionListener)new InfoAction((MapPane)this.mapPane));
            menu.add(infoMenu);
            JRadioButtonMenuItem zoomInMenu = new JRadioButtonMenuItem("Zoom in");
            group.add(zoomInMenu);
            a = new ZoomInAction((MapPane)this.mapPane);
            zoomInMenu.setMnemonic('+');
            zoomInMenu.setIcon((Icon)a.getValue("SmallIcon"));
            zoomInMenu.addActionListener((ActionListener)a);
            menu.add(zoomInMenu);
            JRadioButtonMenuItem zoomOutMenu = new JRadioButtonMenuItem("Zoom out");
            group.add(zoomOutMenu);
            zoomOutMenu.setMnemonic('-');
            a = new ZoomOutAction((MapPane)this.mapPane);
            zoomOutMenu.setIcon((Icon)a.getValue("SmallIcon"));
            zoomOutMenu.addActionListener((ActionListener)a);
            menu.add(zoomOutMenu);
            try {
                String url = nodeModel.m_urlWMS.getStringValue();
                WebMapServer wms = new WebMapServer(new URL(url));
                WMSCapabilities capabilities = wms.getCapabilities();
                Layer[] layers = WMSUtils.getNamedLayers((WMSCapabilities)capabilities);
                menu.addSeparator();
                this.overlays = new LinkedList();
                ButtonGroup groupLayers = new ButtonGroup();
                JRadioButtonMenuItem overlayNone = new JRadioButtonMenuItem("no overlay");
                overlayNone.setSelected(false);
                overlayNone.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
                groupLayers.add(overlayNone);
                menu.add(overlayNone);
                int i = 0;
                Layer[] layerArray = layers;
                int n = layers.length;
                int n2 = 0;
                while (n2 < n) {
                    Layer layer = layerArray[n2];
                    WMSLayer l = new WMSLayer(wms, layer);
                    l.setVisible(i == 0);
                    this.content.addLayer((org.geotools.map.Layer)l);
                    this.overlays.add(l);
                    JRadioButtonMenuItem overlayMenu = new JRadioButtonMenuItem("layer " + layer.getName());
                    overlayMenu.setSelected(i == 0);
                    int index = i++;
                    overlayMenu.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
                    groupLayers.add(overlayMenu);
                    menu.add(overlayMenu);
                    ++n2;
                }
            }
            catch (IOException | ServiceException e) {
                e.printStackTrace();
                logger.warn((Object)("unable to load overlay: " + e.getMessage()));
            }
            menuBar.add(menu);
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            logger.warn((Object)"unable to display toolbars");
        }
        this.mapPane.addMapPaneListener((MapPaneListener)new /* Unavailable Anonymous Inner Class!! */);
        this.mapPane.addMouseListener((MapMouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void uncheckAll() {
    }

    protected void modelChanged() {
        DisplaySpatialPopulationNodeModel nodeModel = (DisplaySpatialPopulationNodeModel)this.getNodeModel();
        assert (nodeModel != null);
        if (nodeModel.datastore1 == null) {
            return;
        }
    }

    protected void onClose() {
        try {
            for (org.geotools.map.Layer l : this.content.layers()) {
                l.dispose();
            }
            this.content.dispose();
        }
        catch (RuntimeException e) {
            logger.warn((Object)("error when disposing the view: " + e.getMessage()), (Throwable)e);
        }
    }

    protected Symbolizer createDefaultSymbolizer(SimpleFeatureSource shapefileSource, Fill fill, Stroke stroke, double opacity) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
        StyleBuilder sb = new StyleBuilder();
        GeometryType geomType = ((SimpleFeatureType)shapefileSource.getSchema()).getGeometryDescriptor().getType();
        Object sym = null;
        if (Point.class.isAssignableFrom(geomType.getBinding()) || MultiPoint.class.isAssignableFrom(geomType.getBinding())) {
            Mark circle = sb.createMark("circle", fill, stroke);
            Graphic graph = sb.createGraphic(null, circle, null, 1.0, 5.0, 0.0);
            sym = sf.createPointSymbolizer(graph, null);
        } else {
            sym = Polygon.class.isAssignableFrom(geomType.getBinding()) || MultiPolygon.class.isAssignableFrom(geomType.getBinding()) ? sf.createPolygonSymbolizer(stroke, fill, null) : sf.createLineSymbolizer(stroke, null);
        }
        return sym;
    }

    protected Style createStyleForStore(SimpleFeatureSource shapefileSource, Color color, double opacity) {
        Style shpStyle = null;
        AttributeDescriptor desc = ((SimpleFeatureType)shapefileSource.getSchema()).getDescriptor("color");
        if (desc != null) {
            StyleBuilder sb = new StyleBuilder();
            FilterFactory2 ff = sb.getFilterFactory();
            Style style = sb.createStyle();
            style.setName("MyStyle");
            StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
            Stroke stroke = sf.createStroke(sb.attributeExpression("color"), (Expression)ff.literal(1));
            Fill fill = sf.createFill(sb.attributeExpression("color"), (Expression)ff.literal(opacity));
            Symbolizer sym = this.createDefaultSymbolizer(shapefileSource, fill, stroke, opacity);
            FeatureTypeStyle featureTypeStyle = sf.createFeatureTypeStyle();
            Rule rule1 = sf.createRule();
            rule1.setName("rule1");
            rule1.getDescription().setTitle("City");
            rule1.getDescription().setAbstract("Rule for drawing cities");
            rule1.setFilter((Filter)ff.not((Filter)ff.isNull((Expression)ff.property("color"))));
            rule1.symbolizers().add(sym);
            featureTypeStyle.rules().add(rule1);
            ArrayList<Symbolizer> symbolizers = new ArrayList<Symbolizer>();
            Stroke strokeDefault = sf.createStroke(sb.colorExpression(color), (Expression)ff.literal(1));
            Fill fillDefault = sf.createFill(sb.colorExpression(color), (Expression)ff.literal(opacity));
            Symbolizer sym2 = this.createDefaultSymbolizer(shapefileSource, fillDefault, strokeDefault, opacity);
            symbolizers.add(sym2);
            Rule rule2 = sf.rule("default", null, null, Double.MIN_VALUE, Double.MAX_VALUE, symbolizers, null);
            featureTypeStyle.rules().add(rule2);
            style.featureTypeStyles().add(featureTypeStyle);
            shpStyle = style;
        } else {
            shpStyle = SLD.createSimpleStyle((FeatureType)shapefileSource.getSchema(), (Color)color);
        }
        return shpStyle;
    }

    protected void onOpen() {
        DisplaySpatialPopulationNodeModel nodeModel = (DisplaySpatialPopulationNodeModel)this.getNodeModel();
        double opacity1 = nodeModel.m_opacity1.getDoubleValue();
        double opacity2 = nodeModel.m_opacity1.getDoubleValue();
        if (nodeModel == null || nodeModel.datastore1 == null) {
            logger.warn((Object)"nothing to display");
            return;
        }
        try {
            SimpleFeatureSource shapefileSource = nodeModel.datastore1.getFeatureSource((Name)nodeModel.datastore1.getNames().get(0));
            this.envelope = shapefileSource.getBounds();
            Style shpStyle = this.createStyleForStore(shapefileSource, nodeModel.m_color1.getColorValue(), opacity1);
            FeatureLayer shpLayer = new FeatureLayer((FeatureSource)shapefileSource, shpStyle);
            this.content.addLayer((org.geotools.map.Layer)shpLayer);
            this.mapPane.setDisplayArea((org.opengis.geometry.Envelope)this.content.getMaxBounds());
            if (nodeModel.datastore2 != null) {
                SimpleFeatureSource shapefileSource2 = nodeModel.datastore2.getFeatureSource((Name)nodeModel.datastore2.getNames().get(0));
                this.envelope.expandToInclude((Envelope)shapefileSource2.getBounds());
                Style shpStyle2 = this.createStyleForStore(shapefileSource2, nodeModel.m_color2.getColorValue(), opacity2);
                FeatureLayer shpLayer2 = new FeatureLayer((FeatureSource)shapefileSource2, shpStyle2);
                this.content.addLayer((org.geotools.map.Layer)shpLayer2);
            }
            this.mapPane.setDisplayArea((org.opengis.geometry.Envelope)this.envelope);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error when displaying the map: " + e.getMessage(), e);
        }
    }

    static /* synthetic */ ReferencedEnvelope access$0(DisplaySpatialPopulationNodeView displaySpatialPopulationNodeView) {
        return displaySpatialPopulationNodeView.envelope;
    }

    static /* synthetic */ JMapPane access$1(DisplaySpatialPopulationNodeView displaySpatialPopulationNodeView) {
        return displaySpatialPopulationNodeView.mapPane;
    }

    static /* synthetic */ List access$2(DisplaySpatialPopulationNodeView displaySpatialPopulationNodeView) {
        return displaySpatialPopulationNodeView.overlays;
    }

    static /* synthetic */ NodeModel access$3(DisplaySpatialPopulationNodeView displaySpatialPopulationNodeView) {
        return displaySpatialPopulationNodeView.getNodeModel();
    }

    static /* synthetic */ MapContent access$4(DisplaySpatialPopulationNodeView displaySpatialPopulationNodeView) {
        return displaySpatialPopulationNodeView.content;
    }
}

