/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.properties.coordinates;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.locationtech.jts.geom.Coordinate;

public class CoordinatesOfWKTGeometriesNodeModel
extends NodeModel {
    SettingsModelString m_colname = new SettingsModelString("colname", "coordinates");
    long done = 0L;

    protected CoordinatesOfWKTGeometriesNodeModel() {
        super(1, 1);
    }

    private DataTableSpec createOutputSpec(DataTableSpec inputTableSpec) {
        String colname = this.m_colname.getStringValue();
        ArrayList<DataColumnSpec> newColumnSpecs = new ArrayList<DataColumnSpec>(inputTableSpec.getNumColumns() + 1);
        int i = 0;
        while (i < inputTableSpec.getNumColumns()) {
            newColumnSpecs.add(inputTableSpec.getColumnSpec(i));
            ++i;
        }
        newColumnSpecs.add(new DataColumnSpecCreator(colname, ListCell.getCollectionType((DataType)DoubleCell.TYPE)).createSpec());
        return new DataTableSpec(newColumnSpecs.toArray(new DataColumnSpec[newColumnSpecs.size()]));
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec spec = inSpecs[0];
        if (spec == null) {
            throw new InvalidSettingsException("no table as input");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)spec)) {
            throw new InvalidSettingsException("the input table contains no WKT geometry");
        }
        String colname = this.m_colname.getStringValue();
        if (spec.containsName(colname)) {
            throw new InvalidSettingsException("the table already contains a column named " + colname);
        }
        return new DataTableSpec[]{this.createOutputSpec(spec)};
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        if (!ReferencingFactoryFinder.getAuthorityNames().contains("AUTO")) {
            throw new RuntimeException("No factory for autority AUTO");
        }
        BufferedDataTable inputTable = inData[0];
        DataTableSpec outputSpec = this.createOutputSpec(inputTable.getDataTableSpec());
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        double total = inputTable.size();
        int numberOfCells = inputTable.getDataTableSpec().getNumColumns();
        this.done = 0L;
        SpatialUtils.applyToEachGeometry((BufferedDataTable)inputTable, geomAndRow -> {
            ArrayList<ListCell> cells = new ArrayList<ListCell>(numberOfCells + 1);
            cells.addAll(geomAndRow.row.stream().collect(Collectors.toList()));
            Coordinate[] coords = geomAndRow.geometry.getCoordinates();
            ArrayList<DataCell> cellsInside = new ArrayList<DataCell>(coords.length * 2);
            int i = 0;
            while (i < coords.length) {
                cellsInside.add(DoubleCell.DoubleCellFactory.create((double)coords[i].x));
                cellsInside.add(DoubleCell.DoubleCellFactory.create((double)coords[i].y));
                ++i;
            }
            cells.add(CollectionCellFactory.createListCell(cellsInside));
            DefaultRow row = new DefaultRow(geomAndRow.row.getKey(), cells);
            container.addRowToTable((DataRow)row);
            if (this.done++ % 10L == 0L) {
                exec.checkCanceled();
                exec.setProgress((double)this.done / total, "computing surface of row " + this.done);
            }
        });
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_colname.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

