/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.write.write_to_gml;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.DataTableToGeotoolsMapper;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.IWarningWriter;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.NodeWarningWriter;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.write.write_to_gml.GMLDataTableToGeotoolsMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.io.FilenameUtils;
import org.apache.xmlbeans.impl.common.XMLChar;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.wfs.GML;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelBoolean;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.util.FileUtil;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class WriteWKTToGMLNodeModel
extends NodeModel {
    private final SettingsModelString m_file = new SettingsModelString("filename", null);
    private final SettingsModelString m_version = new SettingsModelString("version", "GML v3");
    protected final SettingsModelBoolean m_writeSchema = new SettingsModelBoolean("write_schema", true);

    protected WriteWKTToGMLNodeModel() {
        super(1, 0);
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        GMLConfiguration config;
        QName qName;
        URL url;
        BufferedDataTable inputPopulation = inData[0];
        if (inputPopulation.size() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("sorry, we can not store more than 2147483647 with this node.");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)inputPopulation.getDataTableSpec())) {
            throw new IllegalArgumentException("the input table contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)inputPopulation.getDataTableSpec())) {
            throw new IllegalArgumentException("the input table contains spatial data but no Coordinate Reference System");
        }
        try {
            url = FileUtil.toURL((String)this.m_file.getStringValue());
        }
        catch (MalformedURLException | InvalidPathException e2) {
            e2.printStackTrace();
            throw new InvalidSettingsException("unable to open URL " + this.m_file.getStringValue() + ": " + e2.getMessage());
        }
        File file = FileUtil.getFileFromURL((URL)url);
        exec.setMessage("encoding entities");
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("entities");
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        builder.setCRS((CoordinateReferenceSystem)crs);
        Class geomClassToBeStored = SpatialUtils.detectGeometryClassFromData((BufferedDataTable)inputPopulation, (String)"the_geom");
        builder.add("the_geom", geomClassToBeStored);
        NodeWarningWriter warnings = new NodeWarningWriter(this.getLogger());
        List<DataTableToGeotoolsMapper> mappers = inputPopulation.getDataTableSpec().stream().filter(colspec -> !"the_geom".equals(colspec.getName())).map(colspec -> new GMLDataTableToGeotoolsMapper((IWarningWriter)warnings, colspec)).collect(Collectors.toList());
        mappers.forEach(mapper -> mapper.addAttributeForSpec(builder));
        SimpleFeatureType type = builder.buildFeatureType();
        int idxColGeom = inputPopulation.getDataTableSpec().findColumnIndex("the_geom");
        GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
        WKTReader reader = new WKTReader(geomFactory);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
        ArrayList<SimpleFeature> toStore = new ArrayList<SimpleFeature>((int)inputPopulation.size());
        try (CloseableRowIterator itRow = inputPopulation.iterator();){
            int currentRow = 0;
            while (itRow.hasNext()) {
                DataRow row = itRow.next();
                DataCell cellGeom = row.getCell(idxColGeom);
                if (cellGeom.isMissing()) continue;
                try {
                    Geometry geom = reader.read(cellGeom.toString());
                    featureBuilder.add((Object)geom);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                int colId = 0;
                int i = 0;
                while (i < row.getNumCells()) {
                    if (i != idxColGeom) {
                        featureBuilder.add(((DataTableToGeotoolsMapper)mappers.get(colId++)).getValueNoNull(row.getCell(i)));
                    }
                    ++i;
                }
                SimpleFeature feature = featureBuilder.buildFeature(row.getKey().toString());
                toStore.add(feature);
                if (currentRow % 10 == 0) {
                    exec.setProgress(0.4 * (double)currentRow / (double)inputPopulation.size(), "encoding entity " + currentRow);
                    exec.checkCanceled();
                }
                ++currentRow;
            }
            toStore.isEmpty();
            exec.setProgress(0.4);
        }
        exec.setMessage("storing entities");
        ListFeatureCollection featureCollection = new ListFeatureCollection(type, toStore);
        GML gml = null;
        String version = this.m_version.getStringValue();
        if ("GML v2".equals(version)) {
            gml = new GML(GML.Version.GML2);
            gml.setLegacy(true);
            qName = null;
            config = null;
        } else if ("GML v3".equals(version)) {
            gml = new GML(GML.Version.WFS1_1);
            gml.setNamespace("location", "location.xsd");
            qName = org.geotools.gml3.GML.FeatureCollection;
            config = new GMLConfiguration();
        } else {
            throw new InvalidSettingsException("unknown GML version " + version);
        }
        Encoder encoder = null;
        if (config != null) {
            encoder = new Encoder((Configuration)config);
            encoder.setIndenting(true);
            encoder.setIndentSize(2);
        }
        gml.setCoordinateReferenceSystem((CoordinateReferenceSystem)crs);
        URL baseurl = file.getParentFile().toURI().toURL();
        String filenameSchema = null;
        if (this.m_writeSchema.getBooleanValue()) {
            exec.setProgress(0.5, "writing the schema");
            filenameSchema = String.valueOf(FilenameUtils.removeExtension((String)file.getAbsolutePath())) + ".xsd";
            this.getLogger().info((Object)("writing the GML schema into " + filenameSchema));
            gml.setBaseURL(new URL("http://schemas.opengis.net"));
            try (FileOutputStream xsd = new FileOutputStream(filenameSchema);){
                gml.encode((OutputStream)xsd, type);
            }
        }
        exec.setProgress(0.6, "writing entities");
        this.getLogger().info((Object)("writing the GML features into " + file));
        try (FileOutputStream os = null;){
            os = new FileOutputStream(file);
            if (config != null) {
                encoder.setSchemaLocation(baseurl.toExternalForm(), FilenameUtils.getName((String)filenameSchema));
                encoder.encode((Object)featureCollection, qName, (OutputStream)os);
            } else {
                if (filenameSchema != null) {
                    gml.setNamespace(baseurl.toExternalForm(), FilenameUtils.getName((String)filenameSchema));
                }
                gml.encode((OutputStream)os, (SimpleFeatureCollection)featureCollection);
            }
        }
        exec.setProgress(1.0);
        this.setWarningMessage(warnings.buildWarnings());
        return new BufferedDataTable[0];
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec specs = inSpecs[0];
        if (this.m_file.getStringValue() == null) {
            throw new IllegalArgumentException("No filename was provided");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)specs)) {
            throw new IllegalArgumentException("the input table contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)specs)) {
            throw new IllegalArgumentException("the input table contains spatial data but no Coordinate Reference System");
        }
        try {
            FileUtil.toURL((String)this.m_file.getStringValue());
        }
        catch (MalformedURLException | InvalidPathException e2) {
            e2.printStackTrace();
            throw new InvalidSettingsException("unable to open URL " + this.m_file.getStringValue() + ": " + e2.getMessage());
        }
        LinkedHashSet<String> invalidColNames = new LinkedHashSet<String>();
        String[] stringArray = specs.getColumnNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String colname = stringArray[n2];
            if (!XMLChar.isValidName((String)colname)) {
                invalidColNames.add(colname);
            }
            ++n2;
        }
        if (!invalidColNames.isEmpty()) {
            if (invalidColNames.size() == 1) {
                throw new IllegalArgumentException("The column \"" + (String)invalidColNames.iterator().next() + "\" contains special characters which cannot be stored as GML. " + "Please use the column rename node to remove these special characters first");
            }
            throw new IllegalArgumentException(String.valueOf(invalidColNames.size()) + " columns contains special characters which cannot be stored as GML. " + "Please use the column rename node to rename these columns: " + String.join((CharSequence)", ", invalidColNames));
        }
        return new DataTableSpec[0];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_file.saveSettingsTo(settings);
        this.m_version.saveSettingsTo(settings);
        this.m_writeSchema.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.loadSettingsFrom(settings);
        this.m_version.loadSettingsFrom(settings);
        this.m_writeSchema.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.validateSettings(settings);
        this.m_version.validateSettings(settings);
        this.m_writeSchema.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

