/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.shapefilesaswkt.read.read_from_kml;

import ch.res_ear.samthiriot.knime.shapefilesaswkt.FeaturesDecodingUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.geotools.kml.v22.KMLConfiguration;
import org.geotools.referencing.CRS;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.MissingCell;
import org.knime.core.data.RowKey;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.util.CheckUtils;
import org.knime.core.util.FileUtil;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.SAXException;

public class ReadKMLAsWKTNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(ReadKMLAsWKTNodeModel.class);
    private final SettingsModelString m_file = new SettingsModelString("filename", null);

    protected ReadKMLAsWKTNodeModel() {
        super(0, 1);
    }

    protected SimpleFeature decodeFileFromKML() throws InvalidSettingsException {
        SimpleFeature f;
        InputStream inputStream;
        URL filename;
        CheckUtils.checkSourceFile((String)this.m_file.getStringValue());
        try {
            filename = FileUtil.toURL((String)this.m_file.getStringValue());
        }
        catch (MalformedURLException | InvalidPathException e2) {
            e2.printStackTrace();
            throw new InvalidSettingsException("unable to open URL " + this.m_file.getStringValue() + ": " + e2.getMessage());
        }
        if (filename == null) {
            throw new InvalidSettingsException("no file defined");
        }
        try {
            inputStream = FileUtil.openStreamWithTimeout((URL)filename);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new IllegalArgumentException("unable to open the URL " + filename + ": " + e2.getMessage());
        }
        Parser parser = new Parser((Configuration)new KMLConfiguration());
        try {
            f = (SimpleFeature)parser.parse(inputStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e2) {
            e2.printStackTrace();
            throw new IllegalArgumentException("Invalid file content " + filename + ": " + e2.getMessage());
        }
        return f;
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        CoordinateReferenceSystem crs;
        exec.setMessage("loading the KML structure");
        SimpleFeature f = this.decodeFileFromKML();
        try {
            crs = CRS.decode((String)"EPSG:4326");
        }
        catch (FactoryException e) {
            throw new RuntimeException("unable to find the Coordinate Reference System EPSG:4326. This error should not happen. Please report this bug for solving.");
        }
        DataTableSpec tableSpec = FeaturesDecodingUtils.createDataTableSpec((SimpleFeature)f, (NodeLogger)this.getLogger(), (CoordinateReferenceSystem)crs);
        BufferedDataContainer container = exec.createDataContainer(tableSpec);
        MissingCell missing = new MissingCell("was null in KML");
        exec.setMessage("reading entries from KML");
        Collection placemarks = (Collection)f.getAttribute("Feature");
        int line = 0;
        if (placemarks != null) {
            double total = placemarks.size();
            for (Object p : placemarks) {
                SimpleFeatureImpl feature = (SimpleFeatureImpl)p;
                ArrayList<Object> cells = new ArrayList<Object>(2 + f.getProperties().size());
                if (feature.getDefaultGeometry() == null) {
                    logger.warn((Object)("ignoring a feature which has no geometry: " + feature));
                    continue;
                }
                cells.add(StringCell.StringCellFactory.create((String)feature.getDefaultGeometry().toString()));
                for (Property property : f.getProperties()) {
                    String name = property.getName().toString();
                    if ("Feature".equals(name) || "LookAt".equals(name) || "Style".equals(name) || "Region".equals(name)) continue;
                    DataCell resultCell = FeaturesDecodingUtils.getDataCellForProperty((Property)property, (SimpleFeature)feature);
                    if (resultCell == null) {
                        cells.add(missing);
                        continue;
                    }
                    cells.add(resultCell);
                }
                container.addRowToTable((DataRow)new DefaultRow(new RowKey("Row_" + line), cells));
                exec.checkCanceled();
                exec.setProgress((double)(++line) / total, "reading KML entity " + line);
            }
        }
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[1];
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_file.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_file.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

