/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.decodewWithDico;

import ch.res_ear.samthiriot.knime.gosp.NodeWarningWriter;
import ch.res_ear.samthiriot.knime.gosp.decodewWithDico.Dictionary;
import ch.res_ear.samthiriot.knime.gosp.decodewWithDico.DictionaryForVariable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.MissingCell;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;

public class DecodeWithDictionaryNodeModel
extends NodeModel {
    private final SettingsModelString m_columnForVarCode = new SettingsModelString("var_code", null);
    private final SettingsModelString m_columnForVarLabel = new SettingsModelString("var_label", null);
    private final SettingsModelString m_columnForModCode = new SettingsModelString("mod_code", null);
    private final SettingsModelString m_columnForModLabel = new SettingsModelString("mod_label", null);
    private final SettingsModelString m_columnForMissing = new SettingsModelString("var_missing", null);
    private final SettingsModelString m_columnForType = new SettingsModelString("var_type", null);

    protected DecodeWithDictionaryNodeModel() {
        super(2, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        return new DataTableSpec[1];
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        NodeWarningWriter warning = new NodeWarningWriter(this.getLogger());
        BufferedDataTable sample = inData[0];
        BufferedDataTable dictionary = inData[1];
        DataTableSpec sampleSpec = sample.getDataTableSpec();
        List columnSpecs = Arrays.stream(sampleSpec.getColumnNames()).map(n -> sampleSpec.getColumnSpec(n)).collect(Collectors.toList());
        Dictionary dico = new Dictionary(dictionary, this.m_columnForVarCode.getStringValue(), this.m_columnForVarLabel.getStringValue(), this.m_columnForModCode.getStringValue(), this.m_columnForModLabel.getStringValue(), this.m_columnForType.getStringValue(), this.m_columnForMissing.getStringValue(), warning);
        List columnDicos = columnSpecs.stream().map(spec -> spec.getName()).map(name -> dico.getDictionaryForVariable(name)).collect(Collectors.toList());
        HashMap variableName2encoded2missing = new HashMap();
        columnDicos.stream().filter(d -> d != null).map(d -> d.variableName).forEach(name -> {
            HashMap hashMap = variableName2encoded2missing.put(name, new HashMap());
        });
        List columnSpecsNew = dico.getSpecsDecodedFromColumn(columnSpecs);
        DataTableSpec sampleSpecNew = new DataTableSpec(sampleSpec.getName(), columnSpecsNew.toArray(new DataColumnSpec[columnSpecsNew.size()]));
        BufferedDataContainer container = exec.createDataContainer(sampleSpecNew);
        long total = sample.size();
        CloseableRowIterator it = sample.iterator();
        long current = 0L;
        while (it.hasNext()) {
            DataRow row = it.next();
            DataCell[] cells = new DataCell[row.getNumCells()];
            int col = 0;
            while (col < row.getNumCells()) {
                DataCell currentCell = row.getCell(col);
                DictionaryForVariable forVar = (DictionaryForVariable)columnDicos.get(col);
                if (forVar == null) {
                    cells[col] = currentCell;
                } else {
                    cells[col] = forVar.getCellForEncoded(currentCell);
                    if (cells[col] == null) {
                        cells[col] = (DataCell)((Map)variableName2encoded2missing.get(((DataColumnSpec)columnSpecs.get(col)).getName())).get(currentCell);
                        if (cells[col] == null) {
                            cells[col] = new MissingCell("no dico mapping for " + currentCell);
                            ((Map)variableName2encoded2missing.get(((DataColumnSpec)columnSpecs.get(col)).getName())).put(currentCell, cells[col]);
                        }
                    }
                }
                ++col;
            }
            container.addRowToTable((DataRow)new DefaultRow(row.getKey(), cells));
            exec.checkCanceled();
            if (current++ % 10L != 0L) continue;
            exec.setProgress((double)current / (double)total, "translating " + row.getKey().getString());
        }
        it.close();
        container.close();
        this.setWarningMessage(warning.buildWarnings());
        return new BufferedDataTable[]{container.getTable()};
    }

    protected void reset() {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_columnForVarCode.saveSettingsTo(settings);
        this.m_columnForVarLabel.saveSettingsTo(settings);
        this.m_columnForModCode.saveSettingsTo(settings);
        this.m_columnForModLabel.saveSettingsTo(settings);
        this.m_columnForMissing.saveSettingsTo(settings);
        this.m_columnForType.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_columnForVarCode.loadSettingsFrom(settings);
        this.m_columnForVarLabel.loadSettingsFrom(settings);
        this.m_columnForModCode.loadSettingsFrom(settings);
        this.m_columnForModLabel.loadSettingsFrom(settings);
        this.m_columnForMissing.loadSettingsFrom(settings);
        this.m_columnForType.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_columnForVarCode.validateSettings(settings);
        this.m_columnForVarLabel.validateSettings(settings);
        this.m_columnForModCode.validateSettings(settings);
        this.m_columnForModLabel.validateSettings(settings);
        this.m_columnForMissing.validateSettings(settings);
        this.m_columnForType.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

