/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp;

import cern.jet.random.Uniform;
import cern.jet.random.engine.MersenneTwister;
import cern.jet.random.engine.RandomEngine;
import ch.res_ear.samthiriot.knime.gosp.IWeightedRandomSampling;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DoubleValue;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.DoubleCell;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;

public abstract class AbstractWeightedRandomSampling
implements IWeightedRandomSampling {
    protected final int seed;
    protected final MersenneTwister random;
    protected final boolean removeWeightColumn;
    protected final boolean shuffle;
    protected final String colnameWeight;
    protected final int idxWeight;
    protected double sum = -1.0;
    protected Uniform randomShufflingCol = null;
    protected static final String COLNAME_SHUFFLING_WEIGHT = "___weight____";

    public AbstractWeightedRandomSampling(boolean autoseed, int providedSeed, boolean removeWeightColumn, String colnameWeight, boolean shuffle, DataTableSpec spec) {
        this(autoseed, providedSeed, removeWeightColumn, colnameWeight, shuffle, spec, -1.0);
    }

    public AbstractWeightedRandomSampling(boolean autoseed, int providedSeed, boolean removeWeightColumn, String colnameWeight, boolean shuffle, DataTableSpec spec, double sum) {
        this.removeWeightColumn = removeWeightColumn;
        this.colnameWeight = colnameWeight;
        this.idxWeight = spec.findColumnIndex(this.colnameWeight);
        this.shuffle = shuffle;
        this.seed = autoseed ? (int)new Date().getTime() : providedSeed;
        this.random = new MersenneTwister(this.seed);
        if (shuffle) {
            this.randomShufflingCol = new Uniform(0.0, 500000.0, (RandomEngine)this.random);
        }
    }

    protected double getSum(BufferedDataTable sample, ExecutionContext exec) throws CanceledExecutionException {
        if (this.sum >= 0.0) {
            return this.sum;
        }
        double _sum = 0.0;
        try (CloseableRowIterator itRow = sample.iterator();){
            long current = 0L;
            long total = sample.size();
            exec.setMessage("summing weights");
            while (itRow.hasNext()) {
                DataRow row = itRow.next();
                _sum += ((DoubleValue)row.getCell(this.idxWeight)).getDoubleValue();
                if (current++ % 100L != 0L) continue;
                exec.setProgress((double)current / (double)total, String.valueOf(current) + "/" + total);
                exec.checkCanceled();
            }
        }
        this.sum = _sum;
        return this.sum;
    }

    protected List<Double> sampleN(int n, double max, ExecutionContext exec) throws CanceledExecutionException {
        exec.setMessage("drawing random numbers");
        ArrayList<Double> weights = new ArrayList<Double>(n);
        Uniform unif = new Uniform(0.0, max, (RandomEngine)this.random);
        int i = 0;
        while (i < n) {
            weights.add(unif.nextDouble());
            if (i % 100 == 0) {
                exec.setProgress((double)i / (double)n, String.valueOf(i) + "/" + n);
                exec.checkCanceled();
            }
            ++i;
        }
        exec.setMessage("sorting random numbers...");
        Collections.sort(weights);
        return weights;
    }

    public DataTableSpec getTableSpecExternal(DataTableSpec spec) {
        if (!this.removeWeightColumn) {
            return spec;
        }
        DataColumnSpec[] novelSpecs = new DataColumnSpec[spec.getNumColumns() - (this.removeWeightColumn ? 1 : 0)];
        int j = 0;
        int i = 0;
        while (i < spec.getNumColumns()) {
            if (!this.removeWeightColumn || this.idxWeight != i) {
                novelSpecs[j++] = spec.getColumnSpec(i);
            }
            ++i;
        }
        return new DataTableSpec(spec.getName(), novelSpecs);
    }

    public DataTableSpec getTableSpecInternal(DataTableSpec spec) {
        if (!this.shuffle) {
            return spec;
        }
        DataColumnSpec[] novelSpecs = new DataColumnSpec[spec.getNumColumns() + 1];
        int i = 0;
        while (i < spec.getNumColumns()) {
            novelSpecs[i] = spec.getColumnSpec(i);
            ++i;
        }
        novelSpecs[novelSpecs.length - 1] = new DataColumnSpecCreator(COLNAME_SHUFFLING_WEIGHT, DoubleCell.TYPE).createSpec();
        return new DataTableSpec(spec.getName(), novelSpecs);
    }

    protected DataRow getRowToStore(String rowId, DataRow row) {
        if (!this.shuffle) {
            return new DefaultRow(rowId, row);
        }
        int colsCount = row.getNumCells() + 1;
        DataCell[] cells = new DataCell[colsCount];
        int i = 0;
        while (i < colsCount - 1) {
            cells[i] = row.getCell(i);
            ++i;
        }
        cells[colsCount - 1] = DoubleCell.DoubleCellFactory.create((double)this.randomShufflingCol.nextDouble());
        return new DefaultRow(rowId, cells);
    }
}

