/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.gosp.multilevel.spatial.composer;

import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelPopulationPortObject;
import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelPopulationPortSpec;
import ch.res_ear.samthiriot.knime.gosp.multilevel.port.MultilevelUtils;
import ch.res_ear.samthiriot.knime.gosp.multilevel.spatial.composer.SpatialComposerUtils;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.map.LRUMap;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureIterator;
import org.knime.core.data.DataCell;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTable;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeLogger;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelIntegerBounded;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.knime.core.node.port.PortObject;
import org.knime.core.node.port.PortObjectSpec;
import org.knime.core.node.port.PortType;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ComposeBySpatialProximityFromTablesNodeModel
extends NodeModel {
    private static final NodeLogger logger = NodeLogger.getLogger(ComposeBySpatialProximityFromTablesNodeModel.class);
    public static final String MODEL_KEY_LINKTYPE_INSIDE = "link_type_inside";
    public static final String MODEL_KEY_LINKTYPE_PROXIMITY = "link_type_proximity";
    public static final String MODEL_KEY_PARENT = "parent_type_name";
    public static final String MODEL_KEY_CHILDREN = "children_type_name";
    public static final String MODEL_KEY_DISTANCE = "max_distance";
    private final SettingsModelString m_linkTypeInside = new SettingsModelString("link_type_inside", "inside");
    private final SettingsModelString m_linkTypeProximity = new SettingsModelString("link_type_proximity", "close to");
    private final SettingsModelString m_parentName = new SettingsModelString("parent_type_name", "parent");
    private final SettingsModelString m_childName = new SettingsModelString("children_type_name", "child");
    private final SettingsModelIntegerBounded m_distance = new SettingsModelIntegerBounded("max_distance", 10, 0, 100);

    protected ComposeBySpatialProximityFromTablesNodeModel() {
        super(new PortType[]{BufferedDataTable.TYPE, BufferedDataTable.TYPE}, new PortType[]{MultilevelPopulationPortObject.TYPE});
    }

    protected MultilevelPopulationPortSpec[] configure(PortObjectSpec[] inSpecs) throws InvalidSettingsException {
        DataTableSpec specsParent = (DataTableSpec)inSpecs[0];
        DataTableSpec specsChild = (DataTableSpec)inSpecs[1];
        if (!SpatialUtils.hasGeometry((DataTableSpec)specsParent)) {
            throw new InvalidSettingsException("the input table for parents contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)specsParent)) {
            throw new InvalidSettingsException("the input table for parents contains spatial data but no Coordinate Reference System");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)specsChild)) {
            throw new InvalidSettingsException("the input table for children contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)specsChild)) {
            throw new InvalidSettingsException("the input table for children contains spatial data but no Coordinate Reference System");
        }
        CoordinateReferenceSystem csrParents = null;
        try {
            csrParents = SpatialUtils.decodeCRS((DataTableSpec)specsParent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        CoordinateReferenceSystem csrChildren = null;
        try {
            csrChildren = SpatialUtils.decodeCRS((DataTableSpec)specsChild);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (csrParents != null && csrChildren != null && !csrParents.getCoordinateSystem().equals(csrChildren.getCoordinateSystem())) {
            throw new InvalidSettingsException("inputs should share the same Reference Coordinates System, but we found " + csrParents.getCoordinateSystem() + " and " + csrChildren.getCoordinateSystem());
        }
        CoordinateReferenceSystem csr = csrParents;
        if (csr == null) {
            csr = csrChildren;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)csr));
        properties.put("crs WKT", csr.toWKT());
        MultilevelPopulationPortSpec specs = new MultilevelPopulationPortSpec(properties);
        specs.addEntityType(this.m_parentName.getStringValue(), specsParent);
        specs.addEntityType(this.m_childName.getStringValue(), specsChild);
        try {
            specs.addLinkType(this.m_linkTypeInside.getStringValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            specs.addLinkType(this.m_linkTypeProximity.getStringValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new MultilevelPopulationPortSpec[]{specs};
    }

    protected MultilevelPopulationPortObject[] execute(PortObject[] inObjects, ExecutionContext exec) throws Exception {
        ExecutionMonitor execProgressSpatialParents = exec.createSubProgress(0.1);
        ExecutionMonitor execProgressSpatialChildren = exec.createSubProgress(0.1);
        ExecutionMonitor execProgressMatchingOne = exec.createSubProgress(0.4);
        ExecutionMonitor execProgressMatchingTwo = exec.createSubProgress(0.4);
        String parentName = this.m_parentName.getStringValue();
        String childName = this.m_childName.getStringValue();
        String linkNameInside = this.m_linkTypeInside.getStringValue();
        String linkNameProximity = this.m_linkTypeProximity.getStringValue();
        Integer maxDistance = this.m_distance.getIntValue();
        BufferedDataTable sampleParentsOrig = (BufferedDataTable)inObjects[0];
        BufferedDataTable sampleChildrenOrig = (BufferedDataTable)inObjects[1];
        exec.setProgress("Cloning " + parentName);
        if (!SpatialUtils.hasGeometry((DataTableSpec)sampleParentsOrig.getDataTableSpec())) {
            throw new IllegalArgumentException("the input table for parents contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)sampleParentsOrig.getDataTableSpec())) {
            throw new IllegalArgumentException("the input table for parents contains spatial data but no Coordinate Reference System");
        }
        if (!SpatialUtils.hasGeometry((DataTableSpec)sampleChildrenOrig.getDataTableSpec())) {
            throw new IllegalArgumentException("the input table for children contains no spatial data (no column named the_geom)");
        }
        if (!SpatialUtils.hasCRS((DataTableSpec)sampleChildrenOrig.getDataTableSpec())) {
            throw new IllegalArgumentException("the input table for children contains spatial data but no Coordinate Reference System");
        }
        CoordinateReferenceSystem csrParents = SpatialUtils.decodeCRS((DataTableSpec)sampleParentsOrig.getDataTableSpec());
        CoordinateReferenceSystem csrChildren = SpatialUtils.decodeCRS((DataTableSpec)sampleChildrenOrig.getDataTableSpec());
        if (!csrParents.getCoordinateSystem().equals(csrChildren.getCoordinateSystem())) {
            throw new IllegalArgumentException("The Coordinate Reference Systems of parents and children should be the same.");
        }
        CoordinateReferenceSystem crs = csrParents;
        DataTableSpec specsParents = MultilevelUtils.getSpecsWithEntityIdColumn((DataTableSpec)sampleParentsOrig.getDataTableSpec(), (String)parentName);
        BufferedDataContainer containerParents = exec.createDataContainer(specsParents);
        CloseableRowIterator itParents = sampleParentsOrig.iterator();
        int indexParent = 0;
        while (itParents.hasNext()) {
            DataRow rowOrig = itParents.next();
            containerParents.addRowToTable(MultilevelUtils.getRowForEntity((String)parentName, (Integer)indexParent, (DataRow)rowOrig));
            ++indexParent;
        }
        itParents.close();
        containerParents.close();
        BufferedDataTable sampleParents = containerParents.getTable();
        exec.setProgress("Cloning " + childName);
        DataTableSpec specsChildren = MultilevelUtils.getSpecsWithEntityIdColumn((DataTableSpec)sampleChildrenOrig.getDataTableSpec(), (String)childName);
        BufferedDataContainer containerChildren = exec.createDataContainer(specsChildren);
        CloseableRowIterator itChild = sampleChildrenOrig.iterator();
        int indexChild = 0;
        while (itChild.hasNext()) {
            DataRow rowOrig = itChild.next();
            containerChildren.addRowToTable(MultilevelUtils.getRowForEntity((String)childName, (Integer)indexChild, (DataRow)rowOrig));
            ++indexChild;
        }
        itChild.close();
        containerChildren.close();
        BufferedDataTable sampleChildren = containerChildren.getTable();
        BufferedDataContainer containerLinks = exec.createDataContainer(MultilevelUtils.getSpecsForLinksTable());
        DataStore datastoreParents = SpatialUtils.createDataStore();
        DataStore datastoreChildren = SpatialUtils.createDataStore();
        String featureParent = "parents";
        String featureChildren = "children";
        exec.setProgress("Spatializing parents & children");
        Runnable runnableSpatializeParents = SpatialUtils.decodeAsFeaturesRunnable((BufferedDataTable)sampleParents, (String)"the_geom", (ExecutionMonitor)execProgressSpatialParents, (DataStore)datastoreParents, (String)"parents", (CoordinateReferenceSystem)crs, (boolean)true, null);
        Runnable runnableSpatializeChildren = SpatialUtils.decodeAsFeaturesRunnable((BufferedDataTable)sampleChildren, (String)"the_geom", (ExecutionMonitor)execProgressSpatialChildren, (DataStore)datastoreChildren, (String)"children", (CoordinateReferenceSystem)crs, (boolean)true, null);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        executor.execute(runnableSpatializeParents);
        executor.execute(runnableSpatializeChildren);
        executor.shutdown();
        try {
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        long totalParents = sampleParents.size();
        long totalChildren = sampleChildren.size();
        exec.setProgress("Matching children inside parents");
        HashSet<Integer> childWithParent = new HashSet<Integer>();
        DataCell cellLinkTypeInside = StringCell.StringCellFactory.create((String)linkNameInside);
        DataCell cellLinkTypeProximity = StringCell.StringCellFactory.create((String)linkNameProximity);
        DataCell cellEntityTypeParent = StringCell.StringCellFactory.create((String)parentName);
        DataCell cellEntityTypeChild = StringCell.StringCellFactory.create((String)childName);
        int idxAttributeIdParent = ((SimpleFeatureType)datastoreParents.getFeatureSource((Name)datastoreParents.getNames().get(0)).getSchema()).indexOf("inc_id");
        int idxAttributeGeomParent = ((SimpleFeatureType)datastoreParents.getFeatureSource((Name)datastoreParents.getNames().get(0)).getSchema()).indexOf("the_geom");
        int idxAttributeIdChild = ((SimpleFeatureType)datastoreChildren.getFeatureSource((Name)datastoreChildren.getNames().get(0)).getSchema()).indexOf("inc_id");
        int idxAttributeGeomChild = ((SimpleFeatureType)datastoreChildren.getFeatureSource((Name)datastoreChildren.getNames().get(0)).getSchema()).indexOf("the_geom");
        SimpleFeatureIterator itParents2 = datastoreParents.getFeatureSource((Name)datastoreParents.getNames().get(0)).getFeatures().features();
        long currentParentIdx = 0L;
        while (itParents2.hasNext()) {
            SimpleFeature parentFeature = (SimpleFeature)itParents2.next();
            Integer idParent = (Integer)parentFeature.getAttribute(idxAttributeIdParent);
            FeatureIterator itChildsComposed = SpatialUtils.findEntitiesWithin((SimpleFeatureSource)datastoreChildren.getFeatureSource((Name)datastoreChildren.getNames().get(0)), (Geometry)((Geometry)parentFeature.getAttribute(idxAttributeGeomParent)));
            while (itChildsComposed.hasNext()) {
                SimpleFeature child = (SimpleFeature)itChildsComposed.next();
                Integer idChild = (Integer)child.getAttribute(idxAttributeIdChild);
                if (childWithParent.contains(idChild)) continue;
                childWithParent.add(idChild);
                containerLinks.addRowToTable(MultilevelUtils.getRowForLink((String)("Link " + containerLinks.size()), (DataCell)cellLinkTypeInside, (Integer)idChild, (DataCell)cellEntityTypeChild, (Integer)idParent, (DataCell)cellEntityTypeParent));
            }
            itChildsComposed.close();
            if (currentParentIdx % 10L == 0L) {
                execProgressMatchingOne.setProgress((double)currentParentIdx / (double)totalParents, "searching inside " + parentName + " " + currentParentIdx);
                execProgressMatchingOne.checkCanceled();
            }
            ++currentParentIdx;
        }
        itParents2.close();
        execProgressMatchingOne.setProgress(1.0);
        long orphanChildren = totalChildren - (long)childWithParent.size();
        logger.error((Object)("Found " + childWithParent.size() + "/" + totalChildren + "; remain " + orphanChildren + " orphans"));
        ArrayList<Integer> orphanIds = new ArrayList<Integer>();
        if (maxDistance > 0) {
            long currentChildIdx = 0L;
            SimpleFeatureIterator itChild2 = datastoreChildren.getFeatureSource((Name)datastoreChildren.getNames().get(0)).getFeatures().features();
            LRUMap childGrom2closestGeom = new LRUMap(1000);
            while (itChild2.hasNext()) {
                SimpleFeature childFeature = (SimpleFeature)itChild2.next();
                Geometry childGeom = (Geometry)childFeature.getAttribute(idxAttributeGeomChild);
                Integer idChild = (Integer)childFeature.getAttribute(idxAttributeIdChild);
                if (currentChildIdx % 10L == 0L) {
                    execProgressMatchingTwo.setProgress((double)currentChildIdx / (double)totalChildren, "searching for " + parentName + " around " + childName + " " + currentChildIdx);
                    execProgressMatchingTwo.checkCanceled();
                }
                ++currentChildIdx;
                if (childWithParent.contains(idChild)) continue;
                SimpleFeature parentFeature = null;
                if (childGrom2closestGeom.containsKey((Object)childGeom)) {
                    parentFeature = (SimpleFeature)childGrom2closestGeom.get((Object)childGeom);
                } else {
                    parentFeature = SpatialUtils.findClosestNeighboorVariableBuffer((Geometry)childGeom, (SimpleFeatureSource)datastoreParents.getFeatureSource((Name)datastoreParents.getNames().get(0)), (int)maxDistance);
                    childGrom2closestGeom.put((Object)childGeom, (Object)parentFeature);
                }
                if (parentFeature != null) {
                    Integer idParent = (Integer)parentFeature.getAttribute(idxAttributeIdParent);
                    containerLinks.addRowToTable(MultilevelUtils.getRowForLink((String)("Link " + containerLinks.size()), (DataCell)cellLinkTypeProximity, (Integer)idChild, (DataCell)cellEntityTypeChild, (Integer)idParent, (DataCell)cellEntityTypeParent));
                    continue;
                }
                orphanIds.add(idChild);
            }
            itChild2.close();
        } else {
            SimpleFeatureIterator itChild3 = datastoreChildren.getFeatureSource((Name)datastoreChildren.getNames().get(0)).getFeatures().features();
            execProgressMatchingTwo.setMessage("counting orphans");
            while (itChild3.hasNext()) {
                SimpleFeature childFeature = (SimpleFeature)itChild3.next();
                Integer idChild = (Integer)childFeature.getAttribute(idxAttributeIdChild);
                if (!childWithParent.contains(idChild)) {
                    orphanIds.add(idChild);
                }
                if (idChild % 50 != 0) continue;
                execProgressMatchingTwo.setProgress((double)idChild.intValue() / (double)totalChildren);
                execProgressMatchingTwo.checkCanceled();
            }
        }
        if (!orphanIds.isEmpty()) {
            this.setWarningMessage(SpatialComposerUtils.getWarningMessageForOrphans(orphanIds));
        }
        execProgressMatchingTwo.setProgress(1.0);
        datastoreParents.dispose();
        datastoreChildren.dispose();
        containerLinks.close();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)crs));
        properties.put("crs WKT", crs.toWKT());
        MultilevelPopulationPortObject res = new MultilevelPopulationPortObject((DataTable)containerLinks.getTable(), new MultilevelPopulationPortSpec(properties));
        res.declareLinkType(linkNameInside);
        if (maxDistance > 0) {
            res.declareLinkType(linkNameProximity);
        }
        res.addPopulation(parentName, (DataTable)sampleParents);
        res.addPopulation(childName, (DataTable)sampleChildren);
        return new MultilevelPopulationPortObject[]{res};
    }

    protected void reset() {
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_linkTypeInside.saveSettingsTo(settings);
        this.m_linkTypeProximity.saveSettingsTo(settings);
        this.m_parentName.saveSettingsTo(settings);
        this.m_childName.saveSettingsTo(settings);
        this.m_distance.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_linkTypeInside.loadSettingsFrom(settings);
        this.m_linkTypeProximity.loadSettingsFrom(settings);
        this.m_parentName.loadSettingsFrom(settings);
        this.m_childName.loadSettingsFrom(settings);
        this.m_distance.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_linkTypeInside.validateSettings(settings);
        this.m_linkTypeProximity.validateSettings(settings);
        this.m_parentName.validateSettings(settings);
        this.m_childName.validateSettings(settings);
        this.m_distance.validateSettings(settings);
    }

    protected void loadInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File internDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }
}

