/*
 * Decompiled with CFR 0.152.
 */
package ch.res_ear.samthiriot.knime.geocoding.google;

import ch.res_ear.samthiriot.knime.geocoding.google.GoogleGeocodingCache;
import ch.res_ear.samthiriot.knime.shapefilesaswkt.SpatialUtils;
import com.google.maps.GeoApiContext;
import com.google.maps.GeocodingApi;
import com.google.maps.errors.ApiException;
import com.google.maps.model.GeocodingResult;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.knime.core.data.DataColumnProperties;
import org.knime.core.data.DataColumnSpec;
import org.knime.core.data.DataColumnSpecCreator;
import org.knime.core.data.DataRow;
import org.knime.core.data.DataTableSpec;
import org.knime.core.data.DataType;
import org.knime.core.data.MissingCell;
import org.knime.core.data.RowKey;
import org.knime.core.data.StringValue;
import org.knime.core.data.collection.CollectionCellFactory;
import org.knime.core.data.collection.ListCell;
import org.knime.core.data.container.CloseableRowIterator;
import org.knime.core.data.def.BooleanCell;
import org.knime.core.data.def.DefaultRow;
import org.knime.core.data.def.StringCell;
import org.knime.core.node.BufferedDataContainer;
import org.knime.core.node.BufferedDataTable;
import org.knime.core.node.CanceledExecutionException;
import org.knime.core.node.ExecutionContext;
import org.knime.core.node.ExecutionMonitor;
import org.knime.core.node.InvalidSettingsException;
import org.knime.core.node.NodeModel;
import org.knime.core.node.NodeSettingsRO;
import org.knime.core.node.NodeSettingsWO;
import org.knime.core.node.defaultnodesettings.SettingsModelString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeocodingGoogleNodeModel
extends NodeModel {
    private final SettingsModelString m_colname_address = new SettingsModelString("colname_address", "address");
    private final SettingsModelString m_api_key = new SettingsModelString("api_key", null);

    protected GeocodingGoogleNodeModel() {
        super(1, 1);
    }

    protected DataTableSpec[] configure(DataTableSpec[] inSpecs) throws InvalidSettingsException {
        if (this.m_api_key.getStringValue() == null) {
            throw new InvalidSettingsException("you should define an API key");
        }
        DataTableSpec spec = inSpecs[0];
        if (spec == null) {
            throw new InvalidSettingsException("no table as input");
        }
        if (spec.containsName("the_geom")) {
            throw new InvalidSettingsException("the input table already contains a column named the_geom");
        }
        if (!spec.containsName(this.m_colname_address.getStringValue())) {
            throw new InvalidSettingsException("unknown column " + this.m_colname_address.getStringValue() + " in the table");
        }
        return new DataTableSpec[]{this.createOutputSpec(spec)};
    }

    private DataTableSpec createOutputSpec(DataTableSpec inputTableSpec) {
        CoordinateReferenceSystem crsTarget = SpatialUtils.getCRSforString((String)"epsg:4326");
        ArrayList<DataColumnSpec> newColumnSpecs = new ArrayList<DataColumnSpec>(inputTableSpec.getNumColumns() + 5);
        int i = 0;
        while (i < inputTableSpec.getNumColumns()) {
            newColumnSpecs.add(inputTableSpec.getColumnSpec(i));
            ++i;
        }
        HashMap<String, String> properties = new HashMap<String, String>(inputTableSpec.getProperties());
        properties.put("crs code", SpatialUtils.getStringForCRS((CoordinateReferenceSystem)crsTarget));
        properties.put("crs WKT", crsTarget.toWKT());
        DataColumnSpecCreator creator = new DataColumnSpecCreator("the_geom", StringCell.TYPE);
        creator.setProperties(new DataColumnProperties(properties));
        newColumnSpecs.add(creator.createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("geometry type", StringCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("is partial", BooleanCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("place id", StringCell.TYPE).createSpec());
        newColumnSpecs.add(new DataColumnSpecCreator("types", ListCell.getCollectionType((DataType)StringCell.TYPE)).createSpec());
        return new DataTableSpec(newColumnSpecs.toArray(new DataColumnSpec[newColumnSpecs.size()]));
    }

    protected BufferedDataTable[] execute(BufferedDataTable[] inData, ExecutionContext exec) throws Exception {
        BufferedDataTable inputTable = inData[0];
        String apiKey = this.m_api_key.getStringValue();
        String colname = this.m_colname_address.getStringValue();
        GeoApiContext geoApiCtxt = new GeoApiContext.Builder().apiKey(apiKey).connectTimeout(60L, TimeUnit.SECONDS).build();
        MissingCell missing = new MissingCell("no location found");
        DataTableSpec outputSpec = this.createOutputSpec(inputTable.getDataTableSpec());
        BufferedDataContainer container = exec.createDataContainer(outputSpec);
        GeometryFactory gf = new GeometryFactory();
        int idxColAddress = inputTable.getSpec().findColumnIndex(colname);
        int countMultipleResults = 0;
        CloseableRowIterator itRow = inputTable.iterator();
        long done = 0L;
        double total = inputTable.size();
        while (itRow.hasNext()) {
            DataRow row = itRow.next();
            if (row.getCell(idxColAddress).isMissing()) {
                this.getLogger().warn((Object)("missing address in row " + row.getKey()));
                ArrayList<Object> cells = new ArrayList<Object>(outputSpec.getNumColumns());
                int i = 0;
                while (i < row.getNumCells()) {
                    cells.add(row.getCell(i));
                    ++i;
                }
                i = 0;
                while (i < 5) {
                    cells.add(missing);
                    ++i;
                }
                container.addRowToTable((DataRow)new DefaultRow(row.getKey(), cells));
                continue;
            }
            String address = ((StringValue)row.getCell(idxColAddress)).getStringValue();
            exec.checkCanceled();
            exec.setProgress((double)done++ / total, "geocoding " + address);
            List<GeocodingResult> results = (List<GeocodingResult>)GoogleGeocodingCache.getInstance().getOSMGeocodingForAddress(address);
            if (results == null) {
                try {
                    GeocodingResult[] resultsRaw = (GeocodingResult[])GeocodingApi.geocode((GeoApiContext)geoApiCtxt, (String)address).await();
                    results = Arrays.asList(resultsRaw);
                }
                catch (ApiException | IOException | InterruptedException e) {
                    e.printStackTrace();
                    throw new RuntimeException("error while geocoding: " + e.getLocalizedMessage());
                }
                GoogleGeocodingCache.getInstance().storeInCache(address, results);
            }
            if (results == null || results.isEmpty()) {
                this.getLogger().warn((Object)("unable to find a location for address " + address));
                ArrayList<Object> cells = new ArrayList<Object>(outputSpec.getNumColumns());
                int i = 0;
                while (i < row.getNumCells()) {
                    cells.add(row.getCell(i));
                    ++i;
                }
                i = 0;
                while (i < 5) {
                    cells.add(missing);
                    ++i;
                }
                container.addRowToTable((DataRow)new DefaultRow(row.getKey(), cells));
                continue;
            }
            if (results.size() > 1) {
                if (++countMultipleResults == 1) {
                    this.setWarningMessage("One address led to multiple locations; one row is created for each location, group the results by address to get only the first result");
                } else {
                    this.setWarningMessage(String.valueOf(countMultipleResults) + " addresses led to multiple locations; one row is created for each location, group the results by address to get only the first result");
                }
            }
            int currentResult = 1;
            for (GeocodingResult result : results) {
                ArrayList<Object> cells = new ArrayList<Object>(outputSpec.getNumColumns());
                int i = 0;
                while (i < row.getNumCells()) {
                    cells.add(row.getCell(i));
                    ++i;
                }
                double latitude = result.geometry.location.lat;
                double longitude = result.geometry.location.lng;
                Point point = gf.createPoint(new Coordinate(longitude, latitude));
                cells.add(StringCell.StringCellFactory.create((String)point.toString()));
                cells.add(StringCell.StringCellFactory.create((String)result.geometry.locationType.name()));
                cells.add(BooleanCell.BooleanCellFactory.create((boolean)result.partialMatch));
                cells.add(StringCell.StringCellFactory.create((String)result.placeId));
                List cellsForTypes = Arrays.asList(result.types).stream().map(t -> t.name()).map(s -> StringCell.StringCellFactory.create((String)s)).collect(Collectors.toList());
                cells.add(CollectionCellFactory.createListCell(cellsForTypes));
                if (results.size() == 1) {
                    container.addRowToTable((DataRow)new DefaultRow(row.getKey(), cells));
                    continue;
                }
                container.addRowToTable((DataRow)new DefaultRow(new RowKey(String.valueOf(row.getKey().getString()) + "_" + currentResult++), cells));
            }
        }
        itRow.close();
        container.close();
        BufferedDataTable out = container.getTable();
        return new BufferedDataTable[]{out};
    }

    protected void saveSettingsTo(NodeSettingsWO settings) {
        this.m_colname_address.saveSettingsTo(settings);
        this.m_api_key.saveSettingsTo(settings);
    }

    protected void loadValidatedSettingsFrom(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname_address.loadSettingsFrom(settings);
        this.m_api_key.loadSettingsFrom(settings);
    }

    protected void validateSettings(NodeSettingsRO settings) throws InvalidSettingsException {
        this.m_colname_address.validateSettings(settings);
        this.m_api_key.validateSettings(settings);
    }

    protected void loadInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void saveInternals(File nodeInternDir, ExecutionMonitor exec) throws IOException, CanceledExecutionException {
    }

    protected void reset() {
    }
}

